/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.protocol.json;

import com.datastax.oss.protocol.internal.Message;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public abstract class MessageSerializer<T extends Message>
extends JsonSerializer<T> {
    public void serialize(T message, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(message);
        this.serializeInner(message, jsonGenerator, serializerProvider);
        this.serializeMessage(message, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    public abstract void serializeMessage(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    void serializeInner(T message, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObjectField("type", (Object)message.getClass().getSimpleName().toUpperCase());
        jsonGenerator.writeObjectField("opcode", (Object)((Message)message).opcode);
        jsonGenerator.writeObjectField("is_response", (Object)((Message)message).isResponse);
    }
}

