/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.stubbing;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.RequestPrime;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.request.Query;
import com.datastax.oss.simulacron.common.result.ErrorResult;
import com.datastax.oss.simulacron.common.result.SuccessResult;
import com.datastax.oss.simulacron.common.result.VoidResult;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.MessageResponseAction;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Prime
extends StubMapping {
    private final RequestPrime primedRequest;
    private static final RowsMetadata rowMetadataForVoid = new RowsMetadata(new LinkedList(), null, new int[]{0}, null);

    public Prime(RequestPrime primedQuery) {
        this.primedRequest = primedQuery;
    }

    public RequestPrime getPrimedRequest() {
        return this.primedRequest;
    }

    @Override
    public boolean matches(Frame frame) {
        return this.primedRequest.when.matches(frame);
    }

    private RowsMetadata fetchRowMetadataForParams(Query query) {
        CodecUtils.ColumnSpecBuilder columnBuilder = CodecUtils.columnSpecBuilder();
        LinkedList columnMetadata = new LinkedList();
        if (query.paramTypes != null) {
            for (String key : query.paramTypes.keySet()) {
                RawType type = CodecUtils.getTypeFromName(query.paramTypes.get(key));
                columnMetadata.add(columnBuilder.apply(key, type));
            }
        }
        return new RowsMetadata(columnMetadata, null, new int[]{0}, null);
    }

    private RowsMetadata fetchRowMetadataForResults(SuccessResult result) {
        if (this.primedRequest.then instanceof SuccessResult) {
            CodecUtils.ColumnSpecBuilder columnBuilder = CodecUtils.columnSpecBuilder();
            LinkedList columnMetadata = new LinkedList();
            for (String key : result.columnTypes.keySet()) {
                RawType type = CodecUtils.getTypeFromName(result.columnTypes.get(key));
                columnMetadata.add(columnBuilder.apply(key, type));
            }
            return new RowsMetadata(columnMetadata, null, new int[]{0}, null);
        }
        return null;
    }

    public Prepared toPrepared() {
        if (this.primedRequest.when instanceof Query) {
            Query query = (Query)this.primedRequest.when;
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putInt(query.getQueryId());
            if (this.primedRequest.then instanceof SuccessResult) {
                SuccessResult result = (SuccessResult)this.primedRequest.then;
                return new Prepared(b.array(), null, this.fetchRowMetadataForParams(query), this.fetchRowMetadataForResults(result));
            }
            if (this.primedRequest.then instanceof VoidResult) {
                return new Prepared(b.array(), null, this.fetchRowMetadataForParams(query), rowMetadataForVoid);
            }
            if (this.primedRequest.then instanceof ErrorResult) {
                return new Prepared(b.array(), null, this.fetchRowMetadataForParams(query), new RowsMetadata(new LinkedList(), null, null, null));
            }
        }
        return null;
    }

    List<Action> toPreparedAction(long delayInMs) {
        Prepared preparedResponse = this.toPrepared();
        MessageResponseAction action = new MessageResponseAction((Message)preparedResponse, delayInMs);
        return Collections.singletonList(action);
    }

    @Override
    public List<Action> getActions(AbstractNode node, Frame frame) {
        if (frame.message instanceof Prepare && this.primedRequest.when instanceof Query) {
            if (this.primedRequest.then instanceof SuccessResult) {
                long delayInMs = !this.primedRequest.then.isIgnoreOnPrepare() ? this.primedRequest.then.getDelayInMs() : 0L;
                return this.toPreparedAction(delayInMs);
            }
            if (this.primedRequest.then instanceof ErrorResult && this.primedRequest.then.isIgnoreOnPrepare()) {
                return this.toPreparedAction(0L);
            }
        }
        return this.primedRequest.then.toActions(node, frame);
    }
}

