/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.Void;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.result.Result;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.MessageResponseAction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class VoidResult
extends Result {
    private List<Action> actions;

    public VoidResult() {
        this(0L, null);
    }

    @JsonCreator
    public VoidResult(@JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(delayInMs, ignoreOnPrepare);
        this.updateActions();
    }

    private void updateActions() {
        this.actions = Collections.singletonList(new MessageResponseAction((Message)Void.INSTANCE, this.delayInMs));
    }

    @Override
    public void setDelay(long delay, TimeUnit delayUnit) {
        super.setDelay(delay, delayUnit);
        this.updateActions();
    }

    @Override
    public List<Action> toActions(AbstractNode node, Frame frame) {
        return this.actions;
    }
}

