/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.error.Unavailable;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.result.ErrorResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class UnavailableResult
extends ErrorResult {
    @JsonProperty(value="consistency_level")
    private final ConsistencyLevel cl;
    @JsonProperty(value="required")
    private final int required;
    @JsonProperty(value="alive")
    private final int alive;

    public UnavailableResult(ConsistencyLevel cl, int required, int alive) {
        this(cl, required, alive, 0L, null);
    }

    @JsonCreator
    UnavailableResult(@JsonProperty(value="consistency_level", required=true) ConsistencyLevel cl, @JsonProperty(value="required", required=true) int required, @JsonProperty(value="alive", required=true) int alive, @JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(4096, "Cannot achieve consistency level " + (Object)((Object)cl), delayInMs, ignoreOnPrepare);
        this.cl = cl;
        this.required = required;
        this.alive = alive;
    }

    @Override
    public Message toMessage() {
        return new Unavailable(this.errorMessage, this.cl.getCode(), this.required, this.alive);
    }
}

