/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.codec.RequestFailureReason;
import com.datastax.oss.simulacron.common.result.ErrorResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class RequestFailureResult
extends ErrorResult {
    @JsonProperty(value="consistency_level")
    protected final ConsistencyLevel cl;
    @JsonProperty(value="received")
    protected final int received;
    @JsonProperty(value="block_for")
    protected final int blockFor;
    @JsonProperty(value="failure_reasons")
    protected final Map<InetAddress, RequestFailureReason> failureReasonByEndpoint;

    protected RequestFailureResult(int errorCode, ConsistencyLevel cl, int received, int blockFor, Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, long delayInMs, Boolean ignoreOnPrepare) {
        super(errorCode, String.format("Operation failed - received %d responses and %d failures", received, failureReasonByEndpoint.size()), delayInMs, ignoreOnPrepare);
        this.cl = cl;
        this.received = received;
        this.blockFor = blockFor;
        this.failureReasonByEndpoint = failureReasonByEndpoint;
    }

    static Map<InetAddress, Integer> toIntMap(Map<InetAddress, RequestFailureReason> failureReasonByEndpoint) {
        return failureReasonByEndpoint.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RequestFailureReason)((Object)((Object)e.getValue()))).getCode()));
    }
}

