/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.error.ReadFailure;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.codec.RequestFailureReason;
import com.datastax.oss.simulacron.common.result.RequestFailureResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.util.Map;

public class ReadFailureResult
extends RequestFailureResult {
    @JsonProperty(value="data_present")
    private final boolean dataPresent;

    public ReadFailureResult(ConsistencyLevel cl, int received, int blockFor, Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, boolean dataPresent) {
        this(cl, received, blockFor, failureReasonByEndpoint, dataPresent, 0L, null);
    }

    @JsonCreator
    public ReadFailureResult(@JsonProperty(value="consistency_level", required=true) ConsistencyLevel cl, @JsonProperty(value="received", required=true) int received, @JsonProperty(value="block_for", required=true) int blockFor, @JsonProperty(value="failure_reasons", required=true) Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, @JsonProperty(value="data_present", required=true) boolean dataPresent, @JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(4864, cl, received, blockFor, failureReasonByEndpoint, delayInMs, ignoreOnPrepare);
        this.dataPresent = dataPresent;
    }

    @Override
    public Message toMessage() {
        return new ReadFailure(this.errorMessage, this.cl.getCode(), this.received, this.blockFor, this.failureReasonByEndpoint.size(), ReadFailureResult.toIntMap(this.failureReasonByEndpoint), this.dataPresent);
    }
}

