/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.result.Result;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.CloseType;
import com.datastax.oss.simulacron.common.stubbing.DisconnectAction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class CloseConnectionResult
extends Result {
    @JsonProperty(value="scope")
    private final DisconnectAction.Scope scope;
    @JsonProperty(value="close_type")
    private final CloseType closeType;

    public CloseConnectionResult(DisconnectAction.Scope scope, CloseType closeType) {
        this(scope, closeType, 0L, null);
    }

    @JsonCreator
    public CloseConnectionResult(@JsonProperty(value="scope") DisconnectAction.Scope scope, @JsonProperty(value="close_type") CloseType closeType, @JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(delayInMs, ignoreOnPrepare);
        this.scope = scope;
        this.closeType = closeType;
    }

    @Override
    public List<Action> toActions(AbstractNode node, Frame frame) {
        DisconnectAction.Builder builder = DisconnectAction.builder().withDelayInMs(this.delayInMs);
        if (this.scope != null) {
            builder.withScope(this.scope);
        }
        if (this.closeType != null) {
            builder.withCloseType(this.closeType);
        }
        return Collections.singletonList(builder.build());
    }
}

