/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.request;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.codec.CqlMapper;
import com.datastax.oss.simulacron.common.request.Batch;
import com.datastax.oss.simulacron.common.request.Options;
import com.datastax.oss.simulacron.common.request.Query;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="request", defaultImpl=Query.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Query.class, name="query"), @JsonSubTypes.Type(value=Options.class, name="options"), @JsonSubTypes.Type(value=Batch.class, name="batch")})
public abstract class Request {
    public abstract boolean matches(Frame var1);

    public static List<ConsistencyLevel> createEnumFromConsistency(String[] consistencies) {
        if (consistencies == null) {
            return new LinkedList<ConsistencyLevel>();
        }
        LinkedList<ConsistencyLevel> consistencyEnum = new LinkedList<ConsistencyLevel>();
        for (String consistency : consistencies) {
            consistencyEnum.add(ConsistencyLevel.fromString(consistency));
        }
        return consistencyEnum;
    }

    public static boolean checkParamsEqual(ByteBuffer buffer, Object primedParam, String stringType, CqlMapper mapper) {
        if (primedParam.equals("*")) {
            return true;
        }
        RawType type = CodecUtils.getTypeFromName(stringType);
        Object nativeParamToCheck = mapper.codecFor(type).decode(buffer);
        Object primedParamToCheck = mapper.codecFor(type).toNativeType(primedParam);
        return primedParamToCheck.equals(nativeParamToCheck);
    }
}

