/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.request.Batch;
import com.datastax.oss.protocol.internal.request.Execute;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.stubbing.Prime;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.SocketAddress;
import java.util.Optional;

public class QueryLog {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="consistency_level")
    private ConsistencyLevel consistency;
    @JsonProperty(value="serial_consistency_level")
    private ConsistencyLevel serialConsistency;
    @JsonProperty(value="connection")
    private SocketAddress connection;
    @JsonProperty(value="received_timestamp")
    private long receivedTimestamp;
    @JsonProperty(value="client_timestamp")
    private long clientTimestamp;
    @JsonProperty(value="primed")
    private boolean primed;
    @JsonProperty(value="frame", access=JsonProperty.Access.READ_ONLY)
    private Frame frame;

    @JsonCreator
    public QueryLog(@JsonProperty(value="query") String query, @JsonProperty(value="consistency_level") ConsistencyLevel consistency, @JsonProperty(value="serial_consistency_level") ConsistencyLevel serialConsistency, @JsonProperty(value="connection") SocketAddress connection, @JsonProperty(value="received_timestamp") long receivedTimestamp, @JsonProperty(value="client_timestamp") long clientTimestamp, @JsonProperty(value="primed") boolean primed) {
        this.query = query;
        this.consistency = consistency;
        this.serialConsistency = serialConsistency;
        this.connection = connection;
        this.clientTimestamp = clientTimestamp;
        this.receivedTimestamp = receivedTimestamp;
        this.primed = primed;
    }

    QueryLog(Frame frame, SocketAddress connection, long receivedTimestamp, boolean primed, Optional<StubMapping> stubOption) {
        this.frame = frame;
        this.connection = connection;
        this.receivedTimestamp = receivedTimestamp;
        this.primed = primed;
        this.type = frame.message.getClass().getSimpleName().toUpperCase();
        if (frame.message instanceof Query) {
            Query query = (Query)frame.message;
            this.query = query.query;
            this.consistency = ConsistencyLevel.fromCode(query.options.consistency);
            this.serialConsistency = ConsistencyLevel.fromCode(query.options.serialConsistency);
            this.clientTimestamp = query.options.defaultTimestamp;
        } else if (frame.message instanceof Execute) {
            StubMapping stub;
            Execute execute = (Execute)frame.message;
            this.consistency = ConsistencyLevel.fromCode(execute.options.consistency);
            this.serialConsistency = ConsistencyLevel.fromCode(execute.options.serialConsistency);
            this.clientTimestamp = execute.options.defaultTimestamp;
            if (stubOption.isPresent() && (stub = stubOption.get()) instanceof Prime) {
                Prime prime = (Prime)stub;
                if (prime.getPrimedRequest().when instanceof com.datastax.oss.simulacron.common.request.Query) {
                    com.datastax.oss.simulacron.common.request.Query query = (com.datastax.oss.simulacron.common.request.Query)prime.getPrimedRequest().when;
                    this.query = query.query;
                }
            }
        } else if (frame.message instanceof Prepare) {
            Prepare prepare = (Prepare)frame.message;
            this.query = prepare.cqlQuery;
        } else if (frame.message instanceof Batch) {
            Batch batch = (Batch)frame.message;
            this.clientTimestamp = batch.defaultTimestamp;
        } else {
            this.query = frame.message.getClass().getSimpleName().toUpperCase();
        }
    }

    public String getType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.serialConsistency;
    }

    public SocketAddress getConnection() {
        return this.connection;
    }

    public long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    @Deprecated
    public long getClientTimestamp() {
        return this.clientTimestamp;
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public String toString() {
        return "QueryLog{type='" + this.type + '\'' + ", query='" + this.query + '\'' + ", consistency=" + (Object)((Object)this.consistency) + ", serialConsistency=" + (Object)((Object)this.serialConsistency) + ", connection=" + this.connection + ", received_timestamp=" + this.receivedTimestamp + ", client_timestamp=" + this.clientTimestamp + ", primed=" + this.primed + '}';
    }
}

