/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.ClusterQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterStructure;
import com.datastax.oss.simulacron.common.cluster.NodeQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.common.cluster.QueryLogReport;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonIgnoreProperties(value={"name"})
public class DataCenterQueryLogReport
extends QueryLogReport
implements DataCenterStructure<ClusterQueryLogReport, NodeQueryLogReport> {
    @JsonManagedReference
    private final Collection<NodeQueryLogReport> nodes = new TreeSet<NodeQueryLogReport>();
    @JsonBackReference
    private final ClusterQueryLogReport parent;

    DataCenterQueryLogReport() {
        this(null, null);
    }

    public DataCenterQueryLogReport(Long id, ClusterQueryLogReport clusterReport) {
        super(id);
        this.parent = clusterReport;
        if (this.parent != null) {
            this.parent.addDataCenter(this);
        }
    }

    void addNode(NodeQueryLogReport node) {
        this.nodes.add(node);
    }

    @Override
    public Collection<NodeQueryLogReport> getNodes() {
        return this.nodes;
    }

    @Override
    public ClusterQueryLogReport getCluster() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCenterQueryLogReport that = (DataCenterQueryLogReport)o;
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return this.nodes != null ? this.nodes.hashCode() : 0;
    }

    @Override
    public ClusterQueryLogReport getRootReport() {
        return this.parent;
    }

    @Override
    public List<QueryLog> getQueryLogs() {
        return this.getNodes().stream().flatMap(n -> n.getQueryLogs().stream()).collect(Collectors.toList());
    }
}

