/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractCluster;
import com.datastax.oss.simulacron.common.cluster.DataCenterSpec;
import com.datastax.oss.simulacron.common.cluster.NodePropertiesBuilder;
import com.datastax.oss.simulacron.common.cluster.NodeSpec;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ClusterSpec
extends AbstractCluster<DataCenterSpec, NodeSpec> {
    @JsonIgnore
    private final transient AtomicLong dcCounter = new AtomicLong(0L);
    @JsonIgnore
    private int numberOfTokens;

    ClusterSpec() {
        this(null, null, null, null, Collections.emptyMap(), 1);
    }

    public ClusterSpec(String name, Long id, String cassandraVersion, String dseVersion, Map<String, Object> peerInfo, int numberOfTokens) {
        super(name, id, cassandraVersion, dseVersion, peerInfo);
        this.numberOfTokens = numberOfTokens;
    }

    public int getNumberOfTokens() {
        return this.numberOfTokens;
    }

    public DataCenterSpec.Builder addDataCenter() {
        return new DataCenterSpec.Builder(this, this.dcCounter.getAndIncrement());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends NodePropertiesBuilder<Builder, ClusterSpec> {
        int[] nodes = null;
        private int numberOfTokens = 1;

        public Builder() {
            super(Builder.class);
        }

        public Builder withNodes(int ... nodeCount) {
            this.nodes = nodeCount;
            return this;
        }

        public Builder withNumberOfTokens(int numberOfTokens) {
            this.numberOfTokens = numberOfTokens;
            return this;
        }

        public ClusterSpec build() {
            ClusterSpec cluster = new ClusterSpec(this.name, this.id, this.cassandraVersion, this.dseVersion, this.peerInfo, this.numberOfTokens);
            if (this.nodes != null) {
                for (int i = 1; i <= this.nodes.length; ++i) {
                    int nodeCount = this.nodes[i - 1];
                    DataCenterSpec dc = ((DataCenterSpec.Builder)cluster.addDataCenter().withName("dc" + i)).build();
                    for (int j = 1; j <= nodeCount; ++j) {
                        ((NodeSpec.Builder)dc.addNode().withName("node" + j)).build();
                    }
                }
            }
            return cluster;
        }
    }
}

