/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractCluster;
import com.datastax.oss.simulacron.common.cluster.AbstractDataCenter;
import com.datastax.oss.simulacron.common.cluster.AbstractNodeProperties;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.datastax.oss.simulacron.common.cluster.NodeStructure;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class AbstractNode<C extends AbstractCluster, D extends AbstractDataCenter<C, ?>>
extends AbstractNodeProperties
implements NodeStructure<C, D> {
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final SocketAddress address;
    @JsonBackReference
    private final D parent;

    public AbstractNode(SocketAddress address, String name, Long id, UUID hostId, String cassandraVersion, String dseVersion, Map<String, Object> peerInfo, D parent) {
        super(name, id, hostId, cassandraVersion, dseVersion, peerInfo);
        this.address = address;
        this.parent = parent;
        if (this.parent != null) {
            ((AbstractDataCenter)parent).addNode((AbstractNode)this);
        }
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress inetSocketAddress() {
        if (this.address instanceof InetSocketAddress) {
            return (InetSocketAddress)this.address;
        }
        return null;
    }

    public InetAddress inet() {
        InetSocketAddress addr = this.inetSocketAddress();
        if (addr != null) {
            return addr.getAddress();
        }
        return null;
    }

    public int port() {
        InetSocketAddress addr = this.inetSocketAddress();
        if (addr != null) {
            return addr.getPort();
        }
        return -1;
    }

    @Override
    public D getDataCenter() {
        return this.parent;
    }

    @Override
    public C getCluster() {
        if (this.parent != null) {
            return (C)((AbstractDataCenter)this.parent).getCluster();
        }
        return null;
    }

    public String toString() {
        return this.toStringWith(", address=" + this.address);
    }

    @Override
    @JsonIgnore
    public Optional<NodeProperties> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Long getActiveConnections() {
        return 0L;
    }
}

