/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.stubbing;

import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.CloseType;

public class DisconnectAction
implements Action {
    private final Scope scope;
    private final long delayInMs;
    private final CloseType closeType;

    DisconnectAction(Scope scope, CloseType closeType, long delayInMs) {
        this.scope = scope;
        this.delayInMs = delayInMs;
        this.closeType = closeType;
    }

    @Override
    public Long delayInMs() {
        return this.delayInMs;
    }

    public Scope getScope() {
        return this.scope;
    }

    public CloseType getCloseType() {
        return this.closeType;
    }

    public String toString() {
        return "DisconnectAction{scope=" + (Object)((Object)this.scope) + ", delayInMs=" + this.delayInMs + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Scope scope = Scope.CONNECTION;
        private CloseType closeType = CloseType.DISCONNECT;
        long delayInMs = 0L;

        public Builder withScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder withCloseType(CloseType closeType) {
            this.closeType = closeType;
            return this;
        }

        public Builder withDelayInMs(long delayInMs) {
            this.delayInMs = delayInMs;
            return this;
        }

        public DisconnectAction build() {
            return new DisconnectAction(this.scope, this.closeType, this.delayInMs);
        }
    }

    public static enum Scope {
        CONNECTION,
        NODE,
        DATA_CENTER,
        CLUSTER;

    }
}

