/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.error.WriteFailure;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.codec.RequestFailureReason;
import com.datastax.oss.simulacron.common.codec.WriteType;
import com.datastax.oss.simulacron.common.result.RequestFailureResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.util.Map;

public class WriteFailureResult
extends RequestFailureResult {
    @JsonProperty(value="write_type")
    private final WriteType writeType;

    public WriteFailureResult(ConsistencyLevel cl, int received, int blockFor, Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, WriteType writeType) {
        this(cl, received, blockFor, failureReasonByEndpoint, writeType, 0L, null);
    }

    @JsonCreator
    public WriteFailureResult(@JsonProperty(value="consistency_level", required=true) ConsistencyLevel cl, @JsonProperty(value="received", required=true) int received, @JsonProperty(value="block_for", required=true) int blockFor, @JsonProperty(value="failure_reasons", required=true) Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, @JsonProperty(value="write_type", required=true) WriteType writeType, @JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(5376, cl, received, blockFor, failureReasonByEndpoint, delayInMs, ignoreOnPrepare);
        this.writeType = writeType;
    }

    @Override
    public Message toMessage() {
        return new WriteFailure(this.errorMessage, this.cl.getCode(), this.received, this.blockFor, this.failureReasonByEndpoint.size(), WriteFailureResult.toIntMap(this.failureReasonByEndpoint), this.writeType.name());
    }
}

