/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.codec.CqlMapper;
import com.datastax.oss.simulacron.common.result.Result;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.datastax.oss.simulacron.common.stubbing.MessageResponseAction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SuccessResult
extends Result {
    @JsonProperty(value="rows")
    public final List<Map<String, Object>> rows;
    @JsonProperty(value="column_types")
    public final Map<String, String> columnTypes;

    public SuccessResult(List<Map<String, Object>> rows, Map<String, String> columnTypes) {
        this(rows, columnTypes, 0L, null);
    }

    @JsonCreator
    public SuccessResult(@JsonProperty(value="rows") List<Map<String, Object>> rows, @JsonProperty(value="column_types") Map<String, String> columnTypes, @JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(delayInMs, ignoreOnPrepare);
        if (rows != null ^ columnTypes != null) {
            throw new IllegalArgumentException("Both \"rows\" and \"columnTypes\" are required or none of them");
        }
        if (rows == null) {
            this.rows = new ArrayList<Map<String, Object>>();
            this.columnTypes = new HashMap<String, String>();
        } else {
            this.rows = rows;
            this.columnTypes = columnTypes;
        }
    }

    @Override
    public List<Action> toActions(AbstractNode node, Frame frame) {
        CqlMapper mapper = CqlMapper.forVersion(frame.protocolVersion);
        LinkedList columnMetadata = new LinkedList();
        CodecUtils.ColumnSpecBuilder columnBuilder = CodecUtils.columnSpecBuilder();
        LinkedList rows = new LinkedList();
        if (this.rows.isEmpty()) {
            for (Map.Entry<String, String> entry : this.columnTypes.entrySet()) {
                columnMetadata.add(columnBuilder.apply(entry.getKey(), CodecUtils.getTypeFromName(entry.getValue())));
            }
        } else {
            boolean metaConstructed = false;
            for (Map<String, Object> row : this.rows) {
                LinkedList<ByteBuffer> rowByteBuffer = new LinkedList<ByteBuffer>();
                for (String key : row.keySet()) {
                    RawType type = CodecUtils.getTypeFromName(this.columnTypes.get(key));
                    if (!metaConstructed) {
                        columnMetadata.add(columnBuilder.apply(key, type));
                    }
                    rowByteBuffer.add(mapper.codecFor(type).encodeObject(row.get(key)));
                }
                metaConstructed = true;
                rows.add(rowByteBuffer);
            }
        }
        RowsMetadata rowMetadata = new RowsMetadata(columnMetadata, null, new int[]{0}, null);
        MessageResponseAction messageResponseAction = new MessageResponseAction((Message)new DefaultRows(rowMetadata, rows), this.getDelayInMs());
        return Collections.singletonList(messageResponseAction);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SuccessResult that = (SuccessResult)o;
        if (!this.rows.equals(that.rows)) {
            return false;
        }
        return this.columnTypes.equals(that.columnTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.rows.hashCode();
        result = 31 * result + this.columnTypes.hashCode();
        return result;
    }
}

