/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.result.AlreadyExistsResult;
import com.datastax.oss.simulacron.common.result.AuthenticationErrorResult;
import com.datastax.oss.simulacron.common.result.CloseConnectionResult;
import com.datastax.oss.simulacron.common.result.ConfigurationErrorResult;
import com.datastax.oss.simulacron.common.result.FunctionFailureResult;
import com.datastax.oss.simulacron.common.result.InvalidResult;
import com.datastax.oss.simulacron.common.result.IsBootstrappingResult;
import com.datastax.oss.simulacron.common.result.NoResult;
import com.datastax.oss.simulacron.common.result.OverloadedResult;
import com.datastax.oss.simulacron.common.result.ProtocolErrorResult;
import com.datastax.oss.simulacron.common.result.ReadFailureResult;
import com.datastax.oss.simulacron.common.result.ReadTimeoutResult;
import com.datastax.oss.simulacron.common.result.ServerErrorResult;
import com.datastax.oss.simulacron.common.result.SuccessResult;
import com.datastax.oss.simulacron.common.result.SyntaxErrorResult;
import com.datastax.oss.simulacron.common.result.TruncateErrorResult;
import com.datastax.oss.simulacron.common.result.UnauthorizedResult;
import com.datastax.oss.simulacron.common.result.UnavailableResult;
import com.datastax.oss.simulacron.common.result.UnpreparedResult;
import com.datastax.oss.simulacron.common.result.VoidResult;
import com.datastax.oss.simulacron.common.result.WriteFailureResult;
import com.datastax.oss.simulacron.common.result.WriteTimeoutResult;
import com.datastax.oss.simulacron.common.stubbing.Action;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.concurrent.TimeUnit;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="result")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SuccessResult.class, name="success"), @JsonSubTypes.Type(value=NoResult.class, name="no_result"), @JsonSubTypes.Type(value=ServerErrorResult.class, name="server_error"), @JsonSubTypes.Type(value=ProtocolErrorResult.class, name="protocol_error"), @JsonSubTypes.Type(value=AuthenticationErrorResult.class, name="authentication_error"), @JsonSubTypes.Type(value=UnavailableResult.class, name="unavailable"), @JsonSubTypes.Type(value=AlreadyExistsResult.class, name="already_exists"), @JsonSubTypes.Type(value=ConfigurationErrorResult.class, name="config_error"), @JsonSubTypes.Type(value=FunctionFailureResult.class, name="function_failure"), @JsonSubTypes.Type(value=InvalidResult.class, name="invalid"), @JsonSubTypes.Type(value=IsBootstrappingResult.class, name="is_bootstrapping"), @JsonSubTypes.Type(value=OverloadedResult.class, name="overloaded"), @JsonSubTypes.Type(value=ReadFailureResult.class, name="read_failure"), @JsonSubTypes.Type(value=ReadTimeoutResult.class, name="read_timeout"), @JsonSubTypes.Type(value=SyntaxErrorResult.class, name="syntax_error"), @JsonSubTypes.Type(value=TruncateErrorResult.class, name="truncate_error"), @JsonSubTypes.Type(value=UnauthorizedResult.class, name="unauthorized"), @JsonSubTypes.Type(value=UnpreparedResult.class, name="unprepared"), @JsonSubTypes.Type(value=WriteFailureResult.class, name="write_failure"), @JsonSubTypes.Type(value=WriteTimeoutResult.class, name="write_timeout"), @JsonSubTypes.Type(value=CloseConnectionResult.class, name="close_connection"), @JsonSubTypes.Type(value=VoidResult.class, name="void")})
public abstract class Result {
    @JsonProperty(value="delay_in_ms")
    protected long delayInMs;
    @JsonProperty(value="ignore_on_prepare")
    protected Boolean ignoreOnPrepare;

    @JsonCreator
    public Result(@JsonProperty(value="delay_in_ms") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        this.delayInMs = delayInMs;
        this.ignoreOnPrepare = ignoreOnPrepare;
    }

    @JsonIgnore
    public long getDelayInMs() {
        return this.delayInMs;
    }

    public void setDelay(long delay, TimeUnit delayUnit) {
        this.delayInMs = TimeUnit.MILLISECONDS.convert(delay, delayUnit);
    }

    public boolean isIgnoreOnPrepare() {
        return this.ignoreOnPrepare == null ? true : this.ignoreOnPrepare;
    }

    @JsonIgnore
    public void setIgnoreOnPrepare(boolean ignoreOnPrepare) {
        this.ignoreOnPrepare = ignoreOnPrepare;
    }

    public abstract List<Action> toActions(AbstractNode var1, Frame var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.delayInMs == result.delayInMs;
    }

    public int hashCode() {
        return (int)(this.delayInMs ^ this.delayInMs >>> 32);
    }
}

