/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.error.AlreadyExists;
import com.datastax.oss.simulacron.common.result.ErrorResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class AlreadyExistsResult
extends ErrorResult {
    @JsonProperty(value="keyspace")
    private final String keyspace;
    @JsonProperty(value="table")
    private final String table;

    public AlreadyExistsResult(String errorMessage, String keyspace, String table) {
        this(errorMessage, keyspace, table, 0L, null);
    }

    public AlreadyExistsResult(String errorMessage, String keyspace) {
        this(errorMessage, keyspace, null, 0L, null);
    }

    @JsonCreator
    public AlreadyExistsResult(@JsonProperty(value="message") String errorMessage, @JsonProperty(value="keyspace", required=true) String keyspace, @JsonProperty(value="table") String table, @JsonProperty(value="delayInMs") long delayInMs, @JsonProperty(value="ignore_on_prepare") Boolean ignoreOnPrepare) {
        super(9216, errorMessage, delayInMs, ignoreOnPrepare);
        this.keyspace = keyspace;
        this.table = table;
    }

    @Override
    public Message toMessage() {
        return new AlreadyExists(this.errorMessage, this.keyspace, this.table != null ? this.table : "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlreadyExistsResult that = (AlreadyExistsResult)o;
        return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyspace, this.table);
    }
}

