/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.request;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.request.Execute;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.codec.CqlMapper;
import com.datastax.oss.simulacron.common.request.Request;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Query
extends Request {
    public final String query;
    public final transient List<ConsistencyLevel> consistencyEnum;
    @JsonProperty(value="param_types")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Map<String, String> paramTypes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Map<String, Object> params;

    public Query(String query) {
        this(query, Collections.emptyList(), null, null);
    }

    @JsonCreator
    public Query(@JsonProperty(value="query") String query, @JsonProperty(value="consistency_level") String[] consistency, @JsonProperty(value="params") Map<String, Object> params, @JsonProperty(value="param_types") Map<String, String> paramTypes) {
        this(query, Query.createEnumFromConsistency(consistency), params, paramTypes);
    }

    public Query(String query, List<ConsistencyLevel> consistencies, Map<String, Object> params, Map<String, String> paramTypes) {
        this.query = query;
        this.consistencyEnum = consistencies;
        this.params = params;
        this.paramTypes = paramTypes;
    }

    @JsonProperty(value="consistency_level")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String[] getConsistency() {
        String[] consistency = new String[this.consistencyEnum.size()];
        for (int i = 0; i < this.consistencyEnum.size(); ++i) {
            consistency[i] = this.consistencyEnum.get(i).toString();
        }
        return consistency;
    }

    @Override
    public boolean matches(Frame frame) {
        if (frame.message instanceof Prepare) {
            Prepare prepare = (Prepare)frame.message;
            if (this.query.equals(prepare.cqlQuery)) {
                return true;
            }
        }
        if (frame.message instanceof Execute) {
            Execute execute = (Execute)frame.message;
            Integer queryIdInt = new BigInteger(execute.queryId).intValue();
            if (this.getQueryId() == queryIdInt.intValue()) {
                return this.checkParamsMatch(execute.options, frame);
            }
        }
        if (frame.message instanceof com.datastax.oss.protocol.internal.request.Query) {
            ConsistencyLevel level;
            com.datastax.oss.protocol.internal.request.Query query = (com.datastax.oss.protocol.internal.request.Query)frame.message;
            if (this.query.equals(query.query) && (this.consistencyEnum.contains((Object)(level = ConsistencyLevel.fromCode(query.options.consistency))) || this.consistencyEnum.size() == 0)) {
                return this.checkParamsMatch(query.options, frame);
            }
        }
        return false;
    }

    private boolean checkParamsMatch(QueryOptions options, Frame frame) {
        block6: {
            CqlMapper mapper;
            block7: {
                if (this.params == null || this.params.size() == 0) {
                    return true;
                }
                if (options.namedValues.size() != this.params.size() && options.positionalValues.size() != this.params.size()) {
                    return false;
                }
                if (options.namedValues.size() == 0 && options.positionalValues.size() == 0 || this.params.size() == 0) break block6;
                mapper = CqlMapper.forVersion(frame.protocolVersion);
                if (options.positionalValues.size() == 0) break block7;
                if (options.positionalValues.size() != this.params.size()) {
                    return false;
                }
                Iterator<Object> primedPositionValues = this.params.values().iterator();
                Iterator<String> primedPositionTypes = this.paramTypes.values().iterator();
                for (ByteBuffer buffer : options.positionalValues) {
                    if (Query.checkParamsEqual(buffer, primedPositionValues.next(), primedPositionTypes.next(), mapper)) continue;
                    return false;
                }
                break block6;
            }
            if (options.namedValues.size() == 0) break block6;
            if (options.namedValues.size() != this.params.size()) {
                return false;
            }
            for (String key : options.namedValues.keySet()) {
                String stringType = this.paramTypes.get(key);
                ByteBuffer buffer = (ByteBuffer)options.namedValues.get(key);
                if (Query.checkParamsEqual(buffer, this.params.get(key), stringType, mapper)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.query != null ? !this.query.equals(query1.query) : query1.query != null) {
            return false;
        }
        return this.consistencyEnum != null ? this.consistencyEnum.equals(query1.consistencyEnum) : query1.consistencyEnum == null;
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.consistencyEnum != null ? this.consistencyEnum.hashCode() : 0);
        result = 31 * result + (this.paramTypes != null ? this.paramTypes.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    @JsonIgnore
    public int getQueryId() {
        return this.query.hashCode();
    }
}

