/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.request;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.request.Request;
import com.datastax.oss.simulacron.common.request.Statement;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.List;

public final class Batch
extends Request {
    @JsonProperty(value="queries")
    public final List<Statement> queries;
    public final transient List<ConsistencyLevel> consistencyEnum;

    @JsonCreator
    public Batch(@JsonProperty(value="queries") List<Statement> queries, @JsonProperty(value="consistency_level") String[] consistency) {
        this(queries, Batch.createEnumFromConsistency(consistency));
    }

    public Batch(List<Statement> queries, List<ConsistencyLevel> consistencies) {
        this.queries = queries;
        this.consistencyEnum = consistencies;
    }

    @JsonProperty(value="queries")
    public List<Statement> getQueries() {
        return this.queries;
    }

    @Override
    public boolean matches(Frame frame) {
        if (frame.message instanceof com.datastax.oss.protocol.internal.request.Batch) {
            com.datastax.oss.protocol.internal.request.Batch batch = (com.datastax.oss.protocol.internal.request.Batch)frame.message;
            ConsistencyLevel level = ConsistencyLevel.fromCode(batch.consistency);
            if (this.consistencyEnum.contains((Object)level) || this.consistencyEnum.size() == 0) {
                if (batch.values.size() != this.queries.size()) {
                    return false;
                }
                Iterator valuesIterator = batch.values.iterator();
                Iterator<Statement> statementIterator = this.queries.iterator();
                Iterator queriesIterator = batch.queriesOrIds.iterator();
                while (valuesIterator.hasNext()) {
                    if (statementIterator.next().checkStatementMatch(frame.protocolVersion, queriesIterator.next(), (List)valuesIterator.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Batch batch = (Batch)o;
        if (!this.queries.equals(batch.queries)) {
            return false;
        }
        return this.consistencyEnum.equals(batch.consistencyEnum);
    }

    public int hashCode() {
        int result = this.queries.hashCode();
        result = 31 * result + this.consistencyEnum.hashCode();
        return result;
    }
}

