/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.codec;

import com.datastax.oss.protocol.internal.response.result.RawType;
import java.util.Arrays;
import java.util.List;

public class Tuple {
    private final RawType.RawTuple tupleType;
    private final List<Object> values;

    public Tuple(RawType.RawTuple tupleType, Object ... values) {
        this(tupleType, Arrays.asList(values));
    }

    public Tuple(RawType.RawTuple tupleType, List<Object> values) {
        this.tupleType = tupleType;
        this.values = values;
    }

    public RawType.RawTuple getTupleType() {
        return this.tupleType;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        if (!this.tupleType.equals((Object)tuple.tupleType)) {
            return false;
        }
        return this.values.equals(tuple.values);
    }

    public int hashCode() {
        int result = this.tupleType.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        return "Tuple{tupleType=" + this.tupleType + ", values=" + this.values + '}';
    }
}

