/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.codec;

import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.util.Bytes;
import com.datastax.oss.simulacron.common.codec.Codec;
import com.datastax.oss.simulacron.common.codec.CodecUtils;
import com.datastax.oss.simulacron.common.codec.InvalidTypeException;
import com.datastax.oss.simulacron.common.codec.ProtocolVersionException;
import com.datastax.oss.simulacron.common.codec.Tuple;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlMapper {
    private static final Logger logger = LoggerFactory.getLogger(CqlMapper.class);
    private final int protocolVersion;
    private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
    private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});
    private final ConcurrentMap<RawType, Codec<?>> cqlTypeCache = new ConcurrentHashMap();
    private final TypeFactory typeFactory = TypeFactory.defaultInstance();
    private static final ConcurrentMap<Integer, CqlMapper> mapperCache = new ConcurrentHashMap<Integer, CqlMapper>();
    public final Codec<String> ascii = new StringCodec("US-ASCII", CodecUtils.primitive(1));
    public final Codec<Long> bigint = new LongCodec(CodecUtils.primitive(2));
    public final Codec<ByteBuffer> blob = new AbstractCodec<ByteBuffer>(ByteBuffer.class, CodecUtils.primitive(3)){

        @Override
        ByteBuffer toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Bytes.fromHexString((String)((String)input));
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(ByteBuffer input) {
            return input.duplicate();
        }

        @Override
        ByteBuffer decodeInternal(ByteBuffer input) {
            return this.encode(input);
        }
    };
    public final Codec<Boolean> bool = new AbstractCodec<Boolean>(Boolean.class, CodecUtils.primitive(4)){

        @Override
        Boolean toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Boolean.parseBoolean((String)input);
            }
            if (input instanceof Number) {
                return ((Number)input).intValue() != 0;
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Boolean input) {
            return input != false ? TRUE.duplicate() : FALSE.duplicate();
        }

        @Override
        Boolean decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return false;
            }
            if (input.remaining() != 1) {
                throw new InvalidTypeException("Invalid boolean value, expecting 1 byte but got " + input.remaining());
            }
            return input.get(input.position()) != 0;
        }
    };
    public final Codec<Long> counter = new LongCodec(CodecUtils.primitive(5));
    public final Codec<BigDecimal> decimal = new AbstractCodec<BigDecimal>(BigDecimal.class, CodecUtils.primitive(6)){

        @Override
        BigDecimal toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return new BigDecimal((String)input);
            }
            if (input instanceof Number) {
                return new BigDecimal(((Number)input).doubleValue());
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(BigDecimal input) {
            BigInteger bi = input.unscaledValue();
            int scale = input.scale();
            byte[] bibytes = bi.toByteArray();
            ByteBuffer bytes = ByteBuffer.allocate(4 + bibytes.length);
            bytes.putInt(scale);
            bytes.put(bibytes);
            bytes.rewind();
            return bytes;
        }

        @Override
        BigDecimal decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return null;
            }
            if (input.remaining() < 4) {
                throw new InvalidTypeException("Invalid decimal value, expecting at least 4 bytes but got " + input.remaining());
            }
            input = input.duplicate();
            int scale = input.getInt();
            byte[] bibytes = new byte[input.remaining()];
            input.get(bibytes);
            BigInteger bi = new BigInteger(bibytes);
            return new BigDecimal(bi, scale);
        }
    };
    public final Codec<Double> cdouble = new AbstractCodec<Double>(Double.class, CodecUtils.primitive(7)){

        @Override
        Double toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Double.parseDouble((String)input);
            }
            if (input instanceof Number) {
                return ((Number)input).doubleValue();
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Double input) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putDouble(0, input);
            return bb;
        }

        @Override
        Double decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return 0.0;
            }
            if (input.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits double value, expecting 8 bytes but got " + input.remaining());
            }
            return input.getDouble(input.position());
        }
    };
    public final Codec<Float> cfloat = new AbstractCodec<Float>(Float.class, CodecUtils.primitive(8)){

        @Override
        Float toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Float.valueOf(Float.parseFloat((String)input));
            }
            if (input instanceof Number) {
                return Float.valueOf(((Number)input).floatValue());
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Float input) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putFloat(0, input.floatValue());
            return bb;
        }

        @Override
        Float decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return Float.valueOf(0.0f);
            }
            if (input.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits float value, expecting 4 bytes but got " + input.remaining());
            }
            return Float.valueOf(input.getFloat(input.position()));
        }
    };
    public final Codec<Integer> cint = new AbstractCodec<Integer>(Integer.class, CodecUtils.primitive(9)){

        @Override
        Integer toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Integer.parseInt((String)input);
            }
            if (input instanceof Number) {
                return ((Number)input).intValue();
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Integer input) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(0, input);
            return bb;
        }

        @Override
        Integer decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return 0;
            }
            if (input.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits integer value, expecting 4 bytes but got " + input.remaining());
            }
            return input.getInt(input.position());
        }
    };
    public final Codec<Date> timestamp = new AbstractCodec<Date>(Date.class, CodecUtils.primitive(11)){

        @Override
        Date toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return new Date(Long.parseLong((String)input));
            }
            if (input instanceof Number) {
                return new Date(((Number)input).longValue());
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Date input) {
            return input == null ? null : CqlMapper.this.bigint.encode(input.getTime());
        }

        @Override
        Date decodeInternal(ByteBuffer input) {
            return input == null || input.remaining() == 0 ? null : new Date(CqlMapper.this.bigint.decode(input));
        }
    };
    public final Codec<UUID> uuid = new UUIDCodec(CodecUtils.primitive(12));
    public final Codec<String> varchar = new StringCodec("UTF-8", CodecUtils.primitive(13));
    public final Codec<BigInteger> varint = new AbstractCodec<BigInteger>(BigInteger.class, CodecUtils.primitive(14)){

        @Override
        BigInteger toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return new BigInteger((String)input);
            }
            if (input instanceof Number) {
                return BigInteger.valueOf(((Number)input).longValue());
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(BigInteger input) {
            return ByteBuffer.wrap(input.toByteArray());
        }

        @Override
        BigInteger decodeInternal(ByteBuffer input) {
            return input == null || input.remaining() == 0 ? null : new BigInteger(Bytes.getArray((ByteBuffer)input));
        }
    };
    public final Codec<UUID> timeuuid = new UUIDCodec(CodecUtils.primitive(15));
    public final Codec<InetAddress> inet = new AbstractCodec<InetAddress>(InetAddress.class, CodecUtils.primitive(16)){

        @Override
        InetAddress toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                try {
                    return InetAddress.getByName((String)input);
                }
                catch (UnknownHostException e) {
                    logger.error("Failure resolving host: ", input, (Object)e);
                }
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(InetAddress input) {
            return ByteBuffer.wrap(input.getAddress());
        }

        @Override
        InetAddress decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return null;
            }
            try {
                return InetAddress.getByAddress(Bytes.getArray((ByteBuffer)input));
            }
            catch (UnknownHostException e) {
                throw new InvalidTypeException("Invalid bytes for inet value, got " + input.remaining() + " bytes", e);
            }
        }
    };
    public final Codec<LocalDate> date = new AbstractCodec<LocalDate>(LocalDate.class, CodecUtils.primitive(17), 4){

        @Override
        LocalDate toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return LocalDate.parse((String)input);
            }
            if (input instanceof Number) {
                return LocalDate.ofEpochDay(((Number)input).longValue());
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(LocalDate input) {
            int unsigned = (int)input.toEpochDay() - Integer.MIN_VALUE;
            return CqlMapper.this.cint.encode(unsigned);
        }

        @Override
        LocalDate decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return null;
            }
            int unsigned = CqlMapper.this.cint.decode(input);
            int signed = unsigned + Integer.MIN_VALUE;
            return LocalDate.ofEpochDay(signed);
        }
    };
    public final Codec<Long> time = new LongCodec(CodecUtils.primitive(18), 4);
    public final Codec<Short> smallint = new AbstractCodec<Short>(Short.class, CodecUtils.primitive(19), 4){

        @Override
        Short toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Short.parseShort((String)input);
            }
            if (input instanceof Number) {
                return ((Number)input).shortValue();
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Short input) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(0, input);
            return bb;
        }

        @Override
        Short decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return (short)0;
            }
            if (input.remaining() != 2) {
                throw new InvalidTypeException("Invalid 16-bits integer value, expecting 2 bytes but got " + input.remaining());
            }
            return input.getShort(input.position());
        }
    };
    public final Codec<Byte> tinyint = new AbstractCodec<Byte>(Byte.class, CodecUtils.primitive(20), 4){

        @Override
        Byte toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Byte.parseByte((String)input);
            }
            if (input instanceof Number) {
                return ((Number)input).byteValue();
            }
            return null;
        }

        @Override
        ByteBuffer encodeInternal(Byte input) {
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, input);
            return bb;
        }

        @Override
        Byte decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return (byte)0;
            }
            if (input.remaining() != 1) {
                throw new InvalidTypeException("Invalid 8-bits integer value, expecting 1 byte but got " + input.remaining());
            }
            return input.get(input.position());
        }
    };

    public static CqlMapper forVersion(int protocolVersion) {
        return mapperCache.computeIfAbsent(protocolVersion, CqlMapper::new);
    }

    private CqlMapper(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    private <T> void register(Codec<T> codec) {
        this.cqlTypeCache.put(codec.getCqlType(), codec);
    }

    private Codec<?> createCodec(RawType key) {
        if (key instanceof RawType.RawSet) {
            RawType.RawSet s = (RawType.RawSet)key;
            Codec elementCodec = this.codecFor(s.elementType);
            return new SetCodec(elementCodec);
        }
        if (key instanceof RawType.RawList) {
            RawType.RawList l = (RawType.RawList)key;
            Codec elementCodec = this.codecFor(l.elementType);
            return new ListCodec(elementCodec);
        }
        if (key instanceof RawType.RawMap) {
            RawType.RawMap m = (RawType.RawMap)key;
            Codec keyCodec = this.codecFor(m.keyType);
            Codec valueCodec = this.codecFor(m.valueType);
            return new MapCodec(keyCodec, valueCodec);
        }
        if (key instanceof RawType.RawTuple) {
            RawType.RawTuple t = (RawType.RawTuple)key;
            List<Codec<Object>> codecs = t.fieldTypes.stream().map(this::codecFor).collect(Collectors.toList());
            return new TupleCodec(t, codecs);
        }
        logger.warn("Could not resolve codec for {}, returning null instead.", (Object)key);
        return null;
    }

    public <T> Codec<T> codecFor(RawType cqlType) {
        if (this.cqlTypeCache.containsKey(cqlType)) {
            return (Codec)this.cqlTypeCache.get(cqlType);
        }
        Codec<?> codec = this.createCodec(cqlType);
        if (codec == null) {
            return null;
        }
        Codec<?> previous = this.cqlTypeCache.putIfAbsent(cqlType, codec);
        return previous == null ? codec : previous;
    }

    private ByteBuffer pack(ByteBuffer[] buffers, int elements) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            int elemSize = this.sizeOfValue(bb);
            size += elemSize;
        }
        ByteBuffer result = ByteBuffer.allocate(this.sizeOfCollectionSize() + size);
        this.writeSize(result, elements);
        for (ByteBuffer bb : buffers) {
            this.writeValue(result, bb);
        }
        return (ByteBuffer)result.flip();
    }

    private int sizeOfValue(ByteBuffer value) {
        return value == null ? 4 : 4 + value.remaining();
    }

    private int sizeOfCollectionSize() {
        return 4;
    }

    private int readSize(ByteBuffer input) {
        return input.getInt();
    }

    private void writeSize(ByteBuffer output, int size) {
        output.putInt(size);
    }

    private ByteBuffer readValue(ByteBuffer input) {
        int size = this.readSize(input);
        return size < 0 ? null : this.readBytes(input, size);
    }

    private ByteBuffer readBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    private void writeValue(ByteBuffer output, ByteBuffer value) {
        output.putInt(value.remaining());
        output.put(value.duplicate());
    }

    class UUIDCodec
    extends AbstractCodec<UUID> {
        UUIDCodec(RawType cqlType) {
            super((Type)((Object)UUID.class), cqlType);
        }

        @Override
        ByteBuffer encodeInternal(UUID input) {
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.putLong(0, input.getMostSignificantBits());
            buf.putLong(8, input.getLeastSignificantBits());
            return buf;
        }

        @Override
        UUID decodeInternal(ByteBuffer input) {
            return input == null || input.remaining() == 0 ? null : new UUID(input.getLong(input.position()), input.getLong(input.position() + 8));
        }

        @Override
        UUID toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return UUID.fromString((String)input);
            }
            return null;
        }
    }

    class LongCodec
    extends AbstractCodec<Long> {
        LongCodec(RawType cqlType) {
            this(cqlType, 0);
        }

        LongCodec(RawType cqlType, int minProtocolVersion) {
            super((Type)((Object)Long.class), cqlType, minProtocolVersion);
        }

        @Override
        ByteBuffer encodeInternal(Long input) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(0, input);
            return bb;
        }

        @Override
        Long decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return 0L;
            }
            if (input.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits long value, expecting 8 bytes but got " + input.remaining());
            }
            return input.getLong(input.position());
        }

        @Override
        Long toNativeTypeInternal(Object input) {
            if (input instanceof String) {
                return Long.parseLong((String)input);
            }
            if (input instanceof Number) {
                return ((Number)input).longValue();
            }
            return null;
        }
    }

    class MapCodec<K, V>
    extends AbstractCodec<Map<K, V>> {
        private final Codec<K> keyCodec;
        private final Codec<V> valueCodec;

        MapCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
            super((Type)CqlMapper.this.typeFactory.constructMapLikeType(Map.class, keyCodec.getJavaType(), valueCodec.getJavaType()), (RawType)new RawType.RawMap(keyCodec.getCqlType(), valueCodec.getCqlType()));
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
        }

        @Override
        ByteBuffer encodeInternal(Map<K, V> input) {
            int i = 0;
            ByteBuffer[] bbs = new ByteBuffer[2 * input.size()];
            for (Map.Entry<K, V> entry : input.entrySet()) {
                ByteBuffer bbv;
                ByteBuffer bbk;
                K key = entry.getKey();
                try {
                    bbk = this.keyCodec.encode(key);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for map key, expecting %s but got %s", this.keyCodec.getJavaType(), key.getClass()), e);
                }
                V value = entry.getValue();
                if (value == null) {
                    throw new NullPointerException("Map values cannot be null");
                }
                try {
                    bbv = this.valueCodec.encode(value);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for map value, expecting %s but got %s", this.valueCodec.getJavaType(), value.getClass()), e);
                }
                bbs[i++] = bbk;
                bbs[i++] = bbv;
            }
            return CqlMapper.this.pack(bbs, input.size());
        }

        @Override
        Map<K, V> decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return new LinkedHashMap();
            }
            try {
                ByteBuffer bytes = input.duplicate();
                int n = CqlMapper.this.readSize(bytes);
                LinkedHashMap<K, V> m = new LinkedHashMap<K, V>(n);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer kbb = CqlMapper.this.readValue(bytes);
                    ByteBuffer vbb = CqlMapper.this.readValue(bytes);
                    m.put(this.keyCodec.decode(kbb), this.valueCodec.decode(vbb));
                }
                return m;
            }
            catch (IllegalArgumentException | BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a map", e);
            }
        }

        @Override
        public Map<K, V> toNativeType(Object input) {
            if (input instanceof Map) {
                HashMap<K, V> map = new HashMap<K, V>();
                Map inMap = (Map)input;
                for (Map.Entry entry : inMap.entrySet()) {
                    K k = this.keyCodec.toNativeType(entry.getKey());
                    V v = this.valueCodec.toNativeType(entry.getValue());
                    map.put(k, v);
                }
                return map;
            }
            return null;
        }
    }

    class TupleCodec
    extends AbstractCodec<Tuple> {
        private final List<Codec<Object>> elementCodecs;
        private final RawType.RawTuple tupleType;

        TupleCodec(RawType.RawTuple tuple, List<Codec<Object>> elementCodecs) {
            super((Type)((Object)Tuple.class), (RawType)tuple);
            this.tupleType = tuple;
            this.elementCodecs = elementCodecs;
        }

        @Override
        ByteBuffer encodeInternal(Tuple input) {
            int size = 0;
            int length = input.getTupleType().fieldTypes.size();
            ByteBuffer[] elements = new ByteBuffer[length];
            for (int i = 0; i < length; ++i) {
                elements[i] = this.elementCodecs.get(i).encode(input.getValues().get(i));
                size += 4 + (elements[i] == null ? 0 : elements[i].remaining());
            }
            ByteBuffer result = ByteBuffer.allocate(size);
            for (ByteBuffer bb : elements) {
                if (bb == null) {
                    result.putInt(-1);
                    continue;
                }
                result.putInt(bb.remaining());
                result.put(bb.duplicate());
            }
            return (ByteBuffer)result.flip();
        }

        @Override
        Tuple decodeInternal(ByteBuffer input) {
            if (input == null) {
                return null;
            }
            ByteBuffer bytes = input.duplicate();
            int numberOfValues = this.tupleType.fieldTypes.size();
            ArrayList<Object> values = new ArrayList<Object>(this.tupleType.fieldTypes.size());
            try {
                for (int i = 0; bytes.hasRemaining() && i < numberOfValues; ++i) {
                    int n = bytes.getInt();
                    ByteBuffer element = n < 0 ? null : CqlMapper.this.readBytes(bytes, n);
                    values.add(this.elementCodecs.get(i).decode(element));
                }
            }
            catch (IllegalArgumentException | BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes top deserialize a tuple", e);
            }
            return new Tuple(this.tupleType, values);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Tuple toNativeType(Object input) {
            List<Object> toTransform = null;
            if (input instanceof Tuple) {
                Tuple inTuple = (Tuple)input;
                if (!inTuple.getTupleType().equals((Object)this.tupleType)) {
                    logger.warn("Attempted to encode mismatching Tuple {} to {}.", (Object)inTuple, (Object)this.tupleType);
                    return null;
                }
                toTransform = ((Tuple)input).getValues();
            } else if (input instanceof Collection && (toTransform = (List<Object>)input).size() != this.tupleType.fieldTypes.size()) {
                logger.warn("Attempted to encode mismatching number of elements from {} to {}", toTransform, (Object)this.tupleType);
                return null;
            }
            if (toTransform == null) {
                return null;
            }
            ArrayList<Object> values = new ArrayList<Object>(this.tupleType.fieldTypes.size());
            Iterator inputIt = toTransform.iterator();
            int i = 0;
            while (i < this.tupleType.fieldTypes.size()) {
                Object next = inputIt.next();
                values.add(this.elementCodecs.get(i).toNativeType(next));
                ++i;
            }
            return new Tuple(this.tupleType, values);
        }
    }

    class ListCodec<E>
    extends CollectionCodec<E, List<E>> {
        ListCodec(Codec<E> elementCodec) {
            super((JavaType)CqlMapper.this.typeFactory.constructCollectionLikeType(List.class, elementCodec.getJavaType()), (RawType)new RawType.RawList(elementCodec.getCqlType()), elementCodec);
        }

        @Override
        protected List<E> newInstance(int size) {
            return new ArrayList(size);
        }
    }

    class SetCodec<E>
    extends CollectionCodec<E, Set<E>> {
        SetCodec(Codec<E> elementCodec) {
            super((JavaType)CqlMapper.this.typeFactory.constructCollectionLikeType(Set.class, elementCodec.getJavaType()), (RawType)new RawType.RawSet(elementCodec.getCqlType()), elementCodec);
        }

        @Override
        protected Set<E> newInstance(int size) {
            return new LinkedHashSet(size);
        }
    }

    abstract class CollectionCodec<E, C extends Collection<E>>
    extends AbstractCodec<C> {
        private final Codec<E> elementCodec;

        CollectionCodec(JavaType javaType, RawType cqlType, Codec<E> elementCodec) {
            super(javaType, cqlType, 1, false);
            this.elementCodec = elementCodec;
        }

        @Override
        ByteBuffer encodeInternal(C input) {
            ByteBuffer[] bbs = new ByteBuffer[input.size()];
            int i = 0;
            for (Object elt : input) {
                ByteBuffer bb;
                if (elt == null) {
                    throw new NullPointerException("Collection elements cannot be null");
                }
                try {
                    bb = this.elementCodec.encode(elt);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException("Invalid type for element", e);
                }
                bbs[i++] = bb;
            }
            return CqlMapper.this.pack(bbs, input.size());
        }

        @Override
        C decodeInternal(ByteBuffer input) {
            if (input == null || input.remaining() == 0) {
                return this.newInstance(0);
            }
            try {
                ByteBuffer i = input.duplicate();
                int size = CqlMapper.this.readSize(i);
                C coll = this.newInstance(size);
                for (int pos = 0; pos < size; ++pos) {
                    ByteBuffer databb = CqlMapper.this.readValue(i);
                    coll.add(this.elementCodec.decode(databb));
                }
                return coll;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize collection", e);
            }
        }

        @Override
        public C toNativeType(Object input) {
            if (input instanceof Collection) {
                Collection in = (Collection)input;
                C transformed = this.newInstance(in.size());
                for (Object o : in) {
                    E e = this.elementCodec.toNativeType(o);
                    transformed.add(e);
                }
                return transformed;
            }
            return null;
        }

        protected abstract C newInstance(int var1);
    }

    class StringCodec
    extends AbstractCodec<String> {
        private final String charset;

        StringCodec(String charset, RawType cqlType) {
            super((Type)((Object)String.class), cqlType);
            this.charset = charset;
        }

        @Override
        ByteBuffer encodeInternal(String input) {
            try {
                return ByteBuffer.wrap(input.getBytes(this.charset));
            }
            catch (UnsupportedEncodingException uee) {
                throw new InvalidTypeException("Invalid input for charset " + this.charset, uee);
            }
        }

        @Override
        public String decodeInternal(ByteBuffer input) {
            if (input == null) {
                return null;
            }
            if (input.remaining() == 0) {
                return "";
            }
            try {
                return new String(Bytes.getArray((ByteBuffer)input), this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidTypeException("Invalid bytes for charset " + this.charset, e);
            }
        }

        @Override
        String toNativeTypeInternal(Object input) {
            return input.toString();
        }
    }

    abstract class AbstractCodec<T>
    implements Codec<T> {
        private final JavaType javaType;
        private final RawType cqlType;
        private final int minProtocolVersion;

        AbstractCodec(Type type, RawType cqlType) {
            this((Type)this$0.typeFactory.constructType(type), cqlType, 0);
        }

        AbstractCodec(Type type, RawType cqlType, int minProtocolVersion) {
            this(this$0.typeFactory.constructType(type), cqlType, minProtocolVersion, true);
        }

        AbstractCodec(JavaType javaType, RawType cqlType, int minProtocolVersion, boolean register) {
            this.javaType = javaType;
            this.cqlType = cqlType;
            this.minProtocolVersion = minProtocolVersion;
            if (register) {
                CqlMapper.this.register(this);
            }
        }

        private void checkProtocolVersion() {
            if (this.minProtocolVersion > CqlMapper.this.protocolVersion) {
                throw new ProtocolVersionException(this.cqlType, CqlMapper.this.protocolVersion, this.minProtocolVersion);
            }
        }

        @Override
        public ByteBuffer encode(T input) {
            this.checkProtocolVersion();
            if (input == null) {
                return null;
            }
            return this.encodeInternal(input);
        }

        @Override
        public T decode(ByteBuffer input) {
            this.checkProtocolVersion();
            return this.decodeInternal(input);
        }

        @Override
        public T toNativeType(Object input) {
            if (input == null) {
                return null;
            }
            if (this.javaType.getRawClass().isAssignableFrom(input.getClass())) {
                return (T)input;
            }
            return this.toNativeTypeInternal(input);
        }

        abstract ByteBuffer encodeInternal(T var1);

        abstract T decodeInternal(ByteBuffer var1);

        T toNativeTypeInternal(Object input) {
            return null;
        }

        @Override
        public JavaType getJavaType() {
            return this.javaType;
        }

        @Override
        public RawType getCqlType() {
            return this.cqlType;
        }
    }
}

