/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class NodePropertiesBuilder<S extends NodePropertiesBuilder<S, N>, N extends NodeProperties> {
    N parent;
    private final S myself;
    String cassandraVersion;
    String dseVersion;
    String name;
    Long id;
    UUID hostId;
    Map<String, Object> peerInfo = new HashMap<String, Object>();

    NodePropertiesBuilder(Class<?> selfType) {
        this(selfType, null);
    }

    NodePropertiesBuilder(Class<?> selfType, N parent) {
        this.myself = (NodePropertiesBuilder)selfType.cast(this);
        this.parent = parent;
    }

    public S copy(NodeProperties toCopy) {
        return ((NodePropertiesBuilder)((NodePropertiesBuilder)((NodePropertiesBuilder)((NodePropertiesBuilder)((NodePropertiesBuilder)this.withCassandraVersion(toCopy.getCassandraVersion())).withDSEVersion(toCopy.getDSEVersion())).withName(toCopy.getName())).withId(toCopy.getId())).withHostId(toCopy.getHostId())).withPeerInfo(toCopy.getPeerInfo());
    }

    public S withCassandraVersion(String cassandraVersion) {
        this.cassandraVersion = cassandraVersion;
        return this.myself;
    }

    public S withDSEVersion(String dseVersion) {
        this.dseVersion = dseVersion;
        return this.myself;
    }

    public S withName(String name) {
        this.name = name;
        return this.myself;
    }

    public S withId(Long id) {
        this.id = id;
        return this.myself;
    }

    public S withHostId(UUID hostId) {
        this.hostId = hostId;
        return this.myself;
    }

    public S withPeerInfo(String key, Object value) {
        this.peerInfo.put(key, value);
        return this.myself;
    }

    public S withPeerInfo(Map<String, Object> peerInfo) {
        this.peerInfo = new HashMap<String, Object>(peerInfo);
        return this.myself;
    }
}

