/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.ClusterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.ConnectionReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.NodeStructure;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(value={"name"})
public class NodeConnectionReport
extends ConnectionReport
implements NodeStructure<ClusterConnectionReport, DataCenterConnectionReport> {
    @JsonProperty
    private final List<SocketAddress> connections;
    @JsonProperty
    private final SocketAddress address;
    @JsonBackReference
    private final DataCenterConnectionReport parent;

    NodeConnectionReport() {
        this(null, Collections.emptyList(), null, null);
    }

    public NodeConnectionReport(Long id, List<SocketAddress> connections, SocketAddress address, DataCenterConnectionReport parent) {
        super(id);
        this.connections = connections;
        this.address = address;
        this.parent = parent;
        if (parent != null) {
            parent.addNode(this);
        }
    }

    @Override
    public List<SocketAddress> getConnections() {
        return this.connections;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    @Override
    public DataCenterConnectionReport getDataCenter() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeConnectionReport that = (NodeConnectionReport)o;
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return this.connections != null ? this.connections.hashCode() : 0;
    }

    @Override
    public ClusterConnectionReport getRootReport() {
        return (ClusterConnectionReport)this.getCluster();
    }
}

