/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.ClusterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.ConnectionReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterStructure;
import com.datastax.oss.simulacron.common.cluster.NodeConnectionReport;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonIgnoreProperties(value={"name"})
public class DataCenterConnectionReport
extends ConnectionReport
implements DataCenterStructure<ClusterConnectionReport, NodeConnectionReport> {
    @JsonManagedReference
    private final Collection<NodeConnectionReport> nodes = new TreeSet<NodeConnectionReport>();
    @JsonBackReference
    private final ClusterConnectionReport parent;

    DataCenterConnectionReport() {
        this(null, null);
    }

    public DataCenterConnectionReport(Long id, ClusterConnectionReport clusterReport) {
        super(id);
        this.parent = clusterReport;
        if (this.parent != null) {
            this.parent.addDataCenter(this);
        }
    }

    void addNode(NodeConnectionReport node) {
        assert (node.getDataCenter() == this);
        this.nodes.add(node);
    }

    @Override
    public Collection<NodeConnectionReport> getNodes() {
        return this.nodes;
    }

    @Override
    public ClusterConnectionReport getCluster() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCenterConnectionReport that = (DataCenterConnectionReport)o;
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return this.nodes != null ? this.nodes.hashCode() : 0;
    }

    @Override
    public ClusterConnectionReport getRootReport() {
        return this.parent;
    }

    @Override
    public List<SocketAddress> getConnections() {
        return this.getNodes().stream().flatMap(n -> n.getConnections().stream()).collect(Collectors.toList());
    }
}

