/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.AbstractNodeProperties;
import com.datastax.oss.simulacron.common.cluster.ClusterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.ClusterStructure;
import com.datastax.oss.simulacron.common.cluster.DataCenterQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.NodeQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.common.cluster.QueryLogReport;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ClusterQueryLogReport
extends QueryLogReport
implements ClusterStructure<DataCenterQueryLogReport, NodeQueryLogReport> {
    @JsonManagedReference
    @JsonProperty(value="data_centers")
    private final Collection<DataCenterQueryLogReport> dataCenters = new TreeSet<DataCenterQueryLogReport>();

    ClusterQueryLogReport() {
        this(null);
    }

    public ClusterQueryLogReport(Long id) {
        super(id);
    }

    public NodeQueryLogReport addNode(AbstractNode node, List<QueryLog> logs) {
        DataCenterQueryLogReport datacenterReport;
        Long dcId = ((AbstractNodeProperties)((Object)node.getDataCenter())).getId();
        Optional<DataCenterQueryLogReport> optionalDatacenterReport = this.dataCenters.stream().filter(dc -> dc.getId().equals(dcId)).findFirst();
        if (optionalDatacenterReport.isPresent()) {
            datacenterReport = optionalDatacenterReport.get();
        } else {
            datacenterReport = new DataCenterQueryLogReport(dcId, this);
            this.addDataCenter(datacenterReport);
        }
        NodeQueryLogReport nodeReport = new NodeQueryLogReport(node.getId(), logs, datacenterReport);
        datacenterReport.addNode(nodeReport);
        return nodeReport;
    }

    void addDataCenter(DataCenterQueryLogReport dataCenter) {
        this.dataCenters.add(dataCenter);
    }

    @Override
    public Collection<DataCenterQueryLogReport> getDataCenters() {
        return this.dataCenters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConnectionReport that = (ClusterConnectionReport)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.dataCenters != null ? this.dataCenters.hashCode() : 0;
    }

    @Override
    public ClusterQueryLogReport getRootReport() {
        return this;
    }

    @Override
    public List<QueryLog> getQueryLogs() {
        return this.getNodes().stream().flatMap(n -> n.getQueryLogs().stream()).collect(Collectors.toList());
    }
}

