/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.AbstractNodeProperties;
import com.datastax.oss.simulacron.common.cluster.ClusterStructure;
import com.datastax.oss.simulacron.common.cluster.ConnectionReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.NodeConnectionReport;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonIgnoreProperties(value={"name"})
public class ClusterConnectionReport
extends ConnectionReport
implements ClusterStructure<DataCenterConnectionReport, NodeConnectionReport> {
    @JsonManagedReference
    @JsonProperty(value="data_centers")
    private final Collection<DataCenterConnectionReport> dataCenters = new TreeSet<DataCenterConnectionReport>();

    ClusterConnectionReport() {
        this(null);
    }

    public ClusterConnectionReport(Long id) {
        super(id);
    }

    @Override
    public ClusterConnectionReport getRootReport() {
        return this;
    }

    public NodeConnectionReport addNode(AbstractNode node, List<SocketAddress> addressList, SocketAddress serverAddress) {
        DataCenterConnectionReport datacenterReport;
        Long dcId = ((AbstractNodeProperties)((Object)node.getDataCenter())).getId();
        Optional<DataCenterConnectionReport> optionalDatacenterReport = this.dataCenters.stream().filter(dc -> dc.getId().equals(dcId)).findFirst();
        if (optionalDatacenterReport.isPresent()) {
            datacenterReport = optionalDatacenterReport.get();
        } else {
            datacenterReport = new DataCenterConnectionReport(dcId, this);
            this.addDataCenter(datacenterReport);
        }
        NodeConnectionReport nodeReport = new NodeConnectionReport(node.getId(), addressList, serverAddress, datacenterReport);
        datacenterReport.addNode(nodeReport);
        return nodeReport;
    }

    void addDataCenter(DataCenterConnectionReport dataCenter) {
        assert (dataCenter.getCluster() == this);
        this.dataCenters.add(dataCenter);
    }

    @Override
    public Collection<DataCenterConnectionReport> getDataCenters() {
        return this.dataCenters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConnectionReport that = (ClusterConnectionReport)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.dataCenters != null ? this.dataCenters.hashCode() : 0;
    }

    @Override
    public List<SocketAddress> getConnections() {
        return this.getNodes().stream().flatMap(n -> n.getConnections().stream()).collect(Collectors.toList());
    }
}

