/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.common.stubbing.InternalStubMapping;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class ActivityLog {
    private Queue<QueryLog> queryLog = new ConcurrentLinkedQueue<QueryLog>();

    public QueryLog addLog(Frame frame, SocketAddress socketAddress, long timestamp, Optional<StubMapping> stubOption) {
        boolean isPrimed = false;
        if (stubOption.isPresent()) {
            StubMapping stub = stubOption.get();
            isPrimed = !(stub instanceof InternalStubMapping);
        }
        QueryLog log = new QueryLog(frame, socketAddress, timestamp, isPrimed, stubOption);
        this.queryLog.add(log);
        return log;
    }

    public void clear() {
        this.queryLog.clear();
    }

    public int getSize() {
        return this.queryLog.size();
    }

    public List<QueryLog> getLogs() {
        return new ArrayList<QueryLog>(this.queryLog);
    }

    public List<QueryLog> getLogs(boolean primed) {
        return this.queryLog.stream().filter(l -> l.isPrimed() == primed).collect(Collectors.toList());
    }
}

