/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractCluster;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.AbstractNodeProperties;
import com.datastax.oss.simulacron.common.cluster.DataCenterStructure;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;

public abstract class AbstractDataCenter<C extends AbstractCluster, N extends AbstractNode>
extends AbstractNodeProperties
implements DataCenterStructure<C, N> {
    @JsonManagedReference
    private final Collection<N> nodes = new ConcurrentSkipListSet<N>();
    @JsonBackReference
    private final C parent;

    public AbstractDataCenter(String name, Long id, String cassandraVersion, String dseVersion, Map<String, Object> peerInfo, C parent) {
        super(name, id, null, cassandraVersion, dseVersion, peerInfo);
        this.parent = parent;
        if (this.parent != null) {
            ((AbstractCluster)parent).addDataCenter((AbstractDataCenter)this);
        }
    }

    @Override
    public C getCluster() {
        return this.parent;
    }

    @Override
    public Collection<N> getNodes() {
        return this.nodes;
    }

    <K extends AbstractNode> void addNode(K node) {
        assert (node.getDataCenter() == this);
        this.nodes.add(node);
    }

    public String toString() {
        return this.toStringWith(", nodes=" + this.nodes.stream().map(n -> n.getId().toString()).collect(Collectors.joining(",")));
    }

    @Override
    public Optional<NodeProperties> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Long getActiveConnections() {
        return this.nodes.stream().mapToLong(NodeProperties::getActiveConnections).sum();
    }
}

