/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractDataCenter;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.AbstractNodeProperties;
import com.datastax.oss.simulacron.common.cluster.ClusterStructure;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;

public abstract class AbstractCluster<D extends AbstractDataCenter<?, N>, N extends AbstractNode>
extends AbstractNodeProperties
implements ClusterStructure<D, N> {
    @JsonManagedReference
    @JsonProperty(value="data_centers")
    private final Collection<D> dataCenters = new ConcurrentSkipListSet<D>();

    public AbstractCluster(String name, Long id, String cassandraVersion, String dseVersion, Map<String, Object> peerInfo) {
        super(name, id, null, cassandraVersion, dseVersion, peerInfo);
    }

    @Override
    public Long getActiveConnections() {
        return this.dataCenters.stream().mapToLong(NodeProperties::getActiveConnections).sum();
    }

    @Override
    public Collection<D> getDataCenters() {
        return this.dataCenters;
    }

    @Override
    public Collection<N> getNodes() {
        return this.getDataCenters().stream().flatMap(dc -> dc.getNodes().stream()).collect(Collectors.toList());
    }

    void addDataCenter(D dataCenter) {
        assert (((AbstractDataCenter)dataCenter).getParent().orElse(null) == this);
        this.dataCenters.add(dataCenter);
    }

    public String toString() {
        return this.toStringWith(", dataCenters=" + this.dataCenters.stream().map(d -> d.getId().toString()).collect(Collectors.joining(",")));
    }

    @Override
    @JsonIgnore
    public Optional<NodeProperties> getParent() {
        return Optional.empty();
    }
}

