/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Bytes {
    private static final byte[] charToByte = new byte[256];
    private static final char[] byteToChar = new char[16];

    private Bytes() {
    }

    public static String toHexString(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.remaining() == 0) {
            return "0x";
        }
        char[] array = new char[2 * (bytes.remaining() + 1)];
        array[0] = 48;
        array[1] = 120;
        return Bytes.toRawHexString(bytes, array, 2);
    }

    private static String toRawHexString(ByteBuffer bytes, char[] array, int offset) {
        int size = bytes.remaining();
        int bytesOffset = bytes.position();
        assert (array.length >= offset + 2 * size);
        for (int i = 0; i < size; ++i) {
            byte bint = bytes.get(i + bytesOffset);
            array[offset + i * 2] = byteToChar[(bint & 0xF0) >> 4];
            array[offset + 1 + i * 2] = byteToChar[bint & 0xF];
        }
        return new String(array);
    }

    public static String toHexString(byte[] byteArray) {
        return Bytes.toHexString(ByteBuffer.wrap(byteArray));
    }

    public static ByteBuffer fromHexString(String str) {
        if ((str.length() & 1) == 1) {
            throw new IllegalArgumentException("A CQL blob string must have an even length (since one byte is always 2 hexadecimal character)");
        }
        if (str.charAt(0) != '0' || str.charAt(1) != 'x') {
            throw new IllegalArgumentException("A CQL blob string must start with \"0x\"");
        }
        return ByteBuffer.wrap(Bytes.fromRawHexString(str, 2));
    }

    private static byte[] fromRawHexString(String str, int strOffset) {
        byte[] bytes = new byte[(str.length() - strOffset) / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte halfByte1 = charToByte[str.charAt(strOffset + i * 2)];
            byte halfByte2 = charToByte[str.charAt(strOffset + i * 2 + 1)];
            if (halfByte1 == -1 || halfByte2 == -1) {
                throw new IllegalArgumentException("Non-hex characters in " + str);
            }
            bytes[i] = (byte)(halfByte1 << 4 | halfByte2);
        }
        return bytes;
    }

    public static byte[] getArray(ByteBuffer bytes) {
        int length = bytes.remaining();
        if (bytes.hasArray()) {
            int boff = bytes.arrayOffset() + bytes.position();
            if (boff == 0 && length == bytes.array().length) {
                return bytes.array();
            }
            return Arrays.copyOfRange(bytes.array(), boff, boff + length);
        }
        byte[] array = new byte[length];
        bytes.duplicate().get(array);
        return array;
    }

    static {
        for (int c = 0; c < charToByte.length; c = (int)((char)(c + 1))) {
            Bytes.charToByte[c] = c >= 48 && c <= 57 ? (int)(c - 48) : (c >= 65 && c <= 70 ? (int)(c - 65 + 10) : (c >= 97 && c <= 102 ? (int)(c - 97 + 10) : -1));
        }
        for (int i = 0; i < 16; ++i) {
            Bytes.byteToChar[i] = Integer.toHexString(i).charAt(0);
        }
    }
}

