/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReadFailure
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;
    public final int numFailures;
    public final Map<InetAddress, Integer> reasonMap;
    public final boolean dataPresent;

    public ReadFailure(String message, int consistencyLevel, int received, int blockFor, int numFailures, Map<InetAddress, Integer> reasonMap, boolean dataPresent) {
        super(4864, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
        this.numFailures = numFailures;
        this.reasonMap = reasonMap;
        this.dataPresent = dataPresent;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(4864, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            ReadFailure readFailure = (ReadFailure)message;
            encoder.writeString(readFailure.message, dest);
            encoder.writeUnsignedShort(readFailure.consistencyLevel, dest);
            encoder.writeInt(readFailure.received, dest);
            encoder.writeInt(readFailure.blockFor, dest);
            if (this.protocolVersion >= 5) {
                SubCodec.writeReasonMap(readFailure.reasonMap, dest, encoder);
            } else {
                encoder.writeInt(readFailure.numFailures, dest);
            }
            encoder.writeByte((byte)(readFailure.dataPresent ? 1 : 0), dest);
        }

        @Override
        public int encodedSize(Message message) {
            ReadFailure readFailure = (ReadFailure)message;
            int size = PrimitiveSizes.sizeOfString(readFailure.message) + 2 + 4 + 4 + 1;
            size = this.protocolVersion >= 5 ? (size += SubCodec.sizeOfReasonMap(readFailure.reasonMap)) : (size += 4);
            return size;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            int numFailures;
            Map<Object, Object> reasonMap;
            String message = decoder.readString(source);
            int consistencyLevel = decoder.readUnsignedShort(source);
            int received = decoder.readInt(source);
            int blockFor = decoder.readInt(source);
            if (this.protocolVersion >= 5) {
                reasonMap = SubCodec.readReasonMap(source, decoder);
                numFailures = reasonMap.size();
            } else {
                reasonMap = Collections.emptyMap();
                numFailures = decoder.readInt(source);
            }
            boolean dataPresent = decoder.readByte(source) != 0;
            return new ReadFailure(message, consistencyLevel, received, blockFor, numFailures, reasonMap, dataPresent);
        }

        static <B> void writeReasonMap(Map<InetAddress, Integer> m, B dest, PrimitiveCodec<B> encoder) {
            encoder.writeInt(m.size(), dest);
            for (Map.Entry<InetAddress, Integer> entry : m.entrySet()) {
                encoder.writeInetAddr(entry.getKey(), dest);
                encoder.writeUnsignedShort(entry.getValue(), dest);
            }
        }

        static int sizeOfReasonMap(Map<InetAddress, Integer> m) {
            int size = 4;
            for (Map.Entry<InetAddress, Integer> entry : m.entrySet()) {
                size += PrimitiveSizes.sizeOfInetAddr(entry.getKey());
                size += 2;
            }
            return size;
        }

        static <B> Map<InetAddress, Integer> readReasonMap(B source, PrimitiveCodec<B> decoder) {
            int length = decoder.readInt(source);
            HashMap<InetAddress, Integer> m = new HashMap<InetAddress, Integer>(length);
            for (int i = 0; i < length; ++i) {
                InetAddress key = decoder.readInetAddr(source);
                int value = decoder.readUnsignedShort(source);
                m.put(key, value);
            }
            return Collections.unmodifiableMap(m);
        }
    }
}

