/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.dse.driver.internal.core.cql.reactive.FailedReactiveResultSet;
import com.datastax.dse.driver.internal.mapper.reactive.FailedMappedReactiveResultSet;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.squareup.javapoet.CodeBlock;

public enum DefaultDaoReturnTypeKind implements DaoReturnTypeKind
{
    VOID{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("execute(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    BOOLEAN{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapWasAppliedToBoolean(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    LONG{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapFirstColumnToLong(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    ROW{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndExtractFirstRow(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapToSingleEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    OPTIONAL_ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapToOptionalEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return execute(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    BOUND_STATEMENT{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return boundStatement", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    PAGING_ITERABLE{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapToEntityIterable(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return innerBlock;
        }
    }
    ,
    FUTURE_OF_VOID{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToVoid(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 10.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_BOOLEAN{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapWasAppliedToBoolean(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 11.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_LONG{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapFirstColumnToLong(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 12.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ROW{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndExtractFirstRow(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 13.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToSingleEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 14.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_OPTIONAL_ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToOptionalEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 15.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ASYNC_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsync(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 16.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ASYNC_PAGING_ITERABLE{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToEntityIterable(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 17.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    REACTIVE_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeReactive(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 18.wrapWithErrorHandling(innerBlock, FAILED_REACTIVE_RESULT_SET);
        }
    }
    ,
    MAPPED_REACTIVE_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeReactiveAndMap(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return 19.wrapWithErrorHandling(innerBlock, FAILED_MAPPED_REACTIVE_RESULT_SET);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            throw new AssertionError((Object)"Should never get here");
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            throw new AssertionError((Object)"Should never get here");
        }
    };

    private static final CodeBlock FAILED_FUTURE;
    private static final CodeBlock FAILED_REACTIVE_RESULT_SET;
    private static final CodeBlock FAILED_MAPPED_REACTIVE_RESULT_SET;

    @Override
    public String getDescription() {
        return this.name();
    }

    static CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, CodeBlock catchBlock) {
        return CodeBlock.builder().beginControlFlow("try", new Object[0]).add(innerBlock).nextControlFlow("catch ($T t)", new Object[]{Throwable.class}).addStatement(catchBlock).endControlFlow().build();
    }

    static {
        FAILED_FUTURE = CodeBlock.of((String)"return $T.failedFuture(t)", (Object[])new Object[]{CompletableFutures.class});
        FAILED_REACTIVE_RESULT_SET = CodeBlock.of((String)"return new $T(t)", (Object[])new Object[]{FailedReactiveResultSet.class});
        FAILED_MAPPED_REACTIVE_RESULT_SET = CodeBlock.of((String)"return new $T(t)", (Object[])new Object[]{FailedMappedReactiveResultSet.class});
    }
}

