/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.Delete;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class DaoDeleteMethodGenerator
extends DaoMethodGenerator {
    public DaoDeleteMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, processedType, enclosingClass, context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.VOID, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_VOID, (Object)DefaultDaoReturnTypeKind.BOOLEAN, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_BOOLEAN, (Object)DefaultDaoReturnTypeKind.RESULT_SET, (Object)DefaultDaoReturnTypeKind.BOUND_STATEMENT, (Object[])new DaoReturnTypeKind[]{DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_RESULT_SET, DefaultDaoReturnTypeKind.REACTIVE_RESULT_SET});
    }

    @Override
    public Optional<MethodSpec> generate() {
        int primaryKeyParameterCount;
        EntityDefinition entityDefinition;
        boolean hasEntityParameter;
        Delete annotation = this.methodElement.getAnnotation(Delete.class);
        assert (annotation != null);
        if (annotation.ifExists() && !annotation.customIfClause().isEmpty()) {
            this.context.getMessager().error(this.methodElement, this.processedType, "Invalid annotation parameters: %s cannot have both ifExists and customIfClause", Delete.class.getSimpleName());
            return Optional.empty();
        }
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        if (parameters.isEmpty()) {
            this.context.getMessager().error(this.methodElement, this.processedType, "Wrong number of parameters: %s methods with no custom clause must take either an entity instance, or the primary key components", Delete.class.getSimpleName());
            return Optional.empty();
        }
        String customWhereClause = annotation.customWhereClause();
        String customIfClause = annotation.customIfClause();
        VariableElement firstParameter = parameters.get(0);
        TypeElement entityElement = EntityUtils.asEntityElement(firstParameter, (Map<Name, TypeElement>)this.typeParameters);
        boolean bl = hasEntityParameter = entityElement != null;
        if (hasEntityParameter) {
            if (!customWhereClause.isEmpty()) {
                this.context.getMessager().error(this.methodElement, this.processedType, "Invalid parameter list: %s methods that have a custom where clause must not take an Entity (%s) as a parameter", Delete.class.getSimpleName(), entityElement.getSimpleName());
            }
            entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
            primaryKeyParameterCount = entityDefinition.getPrimaryKey().size();
        } else {
            entityElement = this.getEntityFromAnnotation();
            if (entityElement == null) {
                this.context.getMessager().error(this.methodElement, this.processedType, "Missing entity class: %s methods that do not operate on an entity instance must have an 'entityClass' argument", Delete.class.getSimpleName());
                return Optional.empty();
            }
            entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
            if (customWhereClause.isEmpty()) {
                List<? extends VariableElement> primaryKeyParameters = parameters;
                if (!customIfClause.isEmpty()) {
                    if (primaryKeyParameters.size() < entityDefinition.getPrimaryKey().size()) {
                        List primaryKeyTypes = entityDefinition.getPrimaryKey().stream().map(d -> d.getType().asTypeName()).collect(Collectors.toList());
                        this.context.getMessager().error(this.methodElement, this.processedType, "Invalid parameter list: %s methods that have a custom if clausemust specify the entire primary key (expected primary keys of %s: %s)", Delete.class.getSimpleName(), entityElement.getSimpleName(), primaryKeyTypes);
                        return Optional.empty();
                    }
                    primaryKeyParameters = primaryKeyParameters.subList(0, entityDefinition.getPrimaryKey().size());
                }
                primaryKeyParameterCount = primaryKeyParameters.size();
                if (!EntityUtils.areParametersValid(entityElement, entityDefinition, primaryKeyParameters, Delete.class, this.context, this.methodElement, this.processedType, "do not operate on an entity instance and lack a custom where clause")) {
                    return Optional.empty();
                }
            } else {
                primaryKeyParameterCount = -1;
            }
        }
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Delete.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generatePrepareRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName, primaryKeyParameterCount));
        CodeBlock.Builder methodBodyBuilder = CodeBlock.builder();
        methodBodyBuilder.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(methodBodyBuilder, this.methodElement);
        this.populateBuilderWithFunction(methodBodyBuilder, boundStatementFunction);
        int nextParameterIndex = 0;
        if (hasEntityParameter) {
            this.warnIfCqlNamePresent(Collections.singletonList(firstParameter));
            for (PropertyDefinition property : entityDefinition.getPrimaryKey()) {
                GeneratedCodePatterns.setValue(property.getCqlName(), property.getType(), CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{firstParameter.getSimpleName(), property.getGetterName()}), "boundStatementBuilder", methodBodyBuilder, this.enclosingClass);
            }
            nextParameterIndex = 1;
        } else if (customWhereClause.isEmpty()) {
            List<CodeBlock> primaryKeyNames = entityDefinition.getPrimaryKey().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList()).subList(0, primaryKeyParameterCount);
            List<? extends VariableElement> bindMarkers = parameters.subList(0, primaryKeyParameterCount);
            this.warnIfCqlNamePresent(bindMarkers);
            GeneratedCodePatterns.bindParameters(bindMarkers, primaryKeyNames, methodBodyBuilder, this.enclosingClass, this.context, false);
            nextParameterIndex = primaryKeyNames.size();
        }
        if (nextParameterIndex < parameters.size()) {
            List<? extends VariableElement> bindMarkers;
            if (customIfClause.isEmpty() && customWhereClause.isEmpty()) {
                this.context.getMessager().error(this.methodElement, this.processedType, "Wrong number of parameters: %s methods can only have additional parameters if they specify a custom WHERE or IF clause", Delete.class.getSimpleName());
            }
            if (this.validateCqlNamesPresent(bindMarkers = parameters.subList(nextParameterIndex, parameters.size()))) {
                GeneratedCodePatterns.bindParameters(bindMarkers, methodBodyBuilder, this.enclosingClass, this.context, false);
            } else {
                return Optional.empty();
            }
        }
        methodBodyBuilder.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        returnType.getKind().addExecuteStatement(methodBodyBuilder, helperFieldName);
        CodeBlock methodBody = returnType.getKind().wrapWithErrorHandling(methodBodyBuilder.build());
        return Optional.of(GeneratedCodePatterns.override(this.methodElement, this.typeParameters).addCode(methodBody).build());
    }

    private TypeElement getEntityFromAnnotation() {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : this.methodElement.getAnnotationMirrors()) {
            if (!this.context.getClassUtils().isSame(annotationMirror2.getAnnotationType(), Delete.class)) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        assert (annotationMirror != null);
        for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("entityClass")) continue;
            List values = (List)((AnnotationValue)entry.getValue()).getValue();
            if (values.isEmpty()) {
                return null;
            }
            TypeMirror mirror = (TypeMirror)((AnnotationValue)values.get(0)).getValue();
            TypeElement element = EntityUtils.asEntityElement(mirror, (Map<Name, TypeElement>)this.typeParameters);
            if (values.size() > 1) {
                this.context.getMessager().warn(this.methodElement, this.processedType, "Too many entity classes: %s must have at most one 'entityClass' argument (will use the first one: %s)", Delete.class.getSimpleName(), element.getSimpleName());
            }
            return element;
        }
        return null;
    }

    private void generatePrepareRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName, int parameterSize) {
        Delete delete = this.methodElement.getAnnotation(Delete.class);
        boolean ifExists = delete.ifExists();
        String customWhereClause = delete.customWhereClause();
        String customIfClause = delete.customIfClause();
        methodBuilder.addCode("$[$T $L = $L", new Object[]{SimpleStatement.class, requestName, helperFieldName});
        if (!customWhereClause.isEmpty()) {
            methodBuilder.addCode(".deleteStart().whereRaw($S)", new Object[]{customWhereClause});
        } else {
            methodBuilder.addCode(".deleteByPrimaryKeyParts($L)", new Object[]{parameterSize});
        }
        if (ifExists) {
            methodBuilder.addCode(".ifExists()", new Object[0]);
        } else if (!customIfClause.isEmpty()) {
            methodBuilder.addCode(".ifRaw($S)", new Object[]{customIfClause});
        }
        methodBuilder.addCode(".build();$]\n", new Object[0]);
    }
}

