/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.data.SettableByName;
import com.datastax.oss.driver.api.mapper.annotations.SetEntity;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.dao.NullSavingStrategyValidation;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DaoSetEntityMethodGenerator
extends DaoMethodGenerator {
    private final NullSavingStrategyValidation nullSavingStrategyValidation;

    public DaoSetEntityMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, processedType, enclosingClass, context);
        this.nullSavingStrategyValidation = new NullSavingStrategyValidation(context);
    }

    @Override
    public Optional<MethodSpec> generate() {
        boolean bl;
        String entityParameterName = null;
        TypeElement entityElement = null;
        String targetParameterName = null;
        if (this.methodElement.getParameters().size() != 2) {
            this.context.getMessager().error(this.methodElement, "Wrong number of parameters: %s methods must have two", SetEntity.class.getSimpleName());
            return Optional.empty();
        }
        TypeMirror targetParameterType = null;
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            TypeElement parameterTypeElement;
            TypeMirror parameterType = variableElement.asType();
            if (this.context.getClassUtils().implementsSettableByName(parameterType)) {
                targetParameterName = variableElement.getSimpleName().toString();
                targetParameterType = variableElement.asType();
                continue;
            }
            if (parameterType.getKind() != TypeKind.DECLARED && parameterType.getKind() != TypeKind.TYPEVAR || (parameterTypeElement = EntityUtils.asEntityElement(parameterType, (Map<Name, TypeElement>)this.typeParameters)) == null) continue;
            entityParameterName = variableElement.getSimpleName().toString();
            entityElement = parameterTypeElement;
        }
        if (entityParameterName == null || targetParameterName == null) {
            this.context.getMessager().error(this.methodElement, "Wrong parameter types: %s methods must take a %s and an annotated entity (in any order)", SetEntity.class.getSimpleName(), SettableByName.class.getSimpleName());
            return Optional.empty();
        }
        TypeMirror returnType = this.methodElement.getReturnType();
        boolean bl2 = bl = returnType.getKind() == TypeKind.VOID;
        if (bl) {
            if (this.context.getClassUtils().isSame(targetParameterType, BoundStatement.class)) {
                this.context.getMessager().warn(this.methodElement, "BoundStatement is immutable, this method will not modify '%s' in place. It should probably return BoundStatement rather than void", targetParameterName);
            }
        } else if (!this.context.getTypeUtils().isSameType(returnType, targetParameterType)) {
            this.context.getMessager().error(this.methodElement, "Invalid return type: %s methods must either be void, or return the same type as their settable parameter (in this case, %s to match '%s')", SetEntity.class.getSimpleName(), targetParameterType, targetParameterName);
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get(entityElement));
        NullSavingStrategy nullSavingStrategy = this.nullSavingStrategyValidation.getNullSavingStrategy(SetEntity.class, SetEntity::nullSavingStrategy, this.methodElement, this.enclosingClass);
        return Optional.of(GeneratedCodePatterns.override(this.methodElement, this.typeParameters).addStatement("$1L$2L.set($3L, $4L, $5T.$6L)", new Object[]{bl ? "" : "return ", helperFieldName, entityParameterName, targetParameterName, NullSavingStrategy.class, nullSavingStrategy}).build());
    }
}

