/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaChangeListenerBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MappedUDTCodec;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingConfiguration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingManager.class);
    private final Session session;
    private final MappingConfiguration configuration;
    final int protocolVersionAsInt;
    private final ConcurrentHashMap<Class<?>, Mapper<?>> mappers = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, MappedUDTCodec<?>> udtCodecs = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Object> accessors = new ConcurrentHashMap();

    public MappingManager(Session session) {
        this(session, MappingManager.getProtocolVersion(session));
    }

    private static ProtocolVersion getProtocolVersion(Session session) {
        session.init();
        return session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    public MappingManager(Session session, ProtocolVersion protocolVersion) {
        this(session, MappingConfiguration.builder().build(), protocolVersion);
    }

    public MappingManager(Session session, MappingConfiguration configuration) {
        this(session, configuration, MappingManager.getProtocolVersion(session));
    }

    public MappingManager(Session session, MappingConfiguration configuration, ProtocolVersion protocolVersion) {
        this.session = session;
        this.configuration = configuration;
        this.protocolVersionAsInt = protocolVersion.toInt();
        session.getCluster().register((SchemaChangeListener)new SchemaChangeListenerBase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTableRemoved(TableMetadata table) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.mappers;
                synchronized (concurrentHashMap) {
                    Iterator it = MappingManager.this.mappers.values().iterator();
                    while (it.hasNext()) {
                        Mapper mapper = (Mapper)it.next();
                        if (!mapper.getTableMetadata().equals((Object)table)) continue;
                        LOGGER.error("Table {} has been removed; existing mappers for @Entity annotated {} will not work anymore", (Object)table.getName(), mapper.getMappedClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTableChanged(TableMetadata current, TableMetadata previous) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.mappers;
                synchronized (concurrentHashMap) {
                    Iterator it = MappingManager.this.mappers.values().iterator();
                    while (it.hasNext()) {
                        Mapper mapper = (Mapper)it.next();
                        if (!mapper.getTableMetadata().equals((Object)previous)) continue;
                        LOGGER.warn("Table {} has been altered; existing mappers for @Entity annotated {} might not work properly anymore", (Object)previous.getName(), mapper.getMappedClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onUserTypeRemoved(UserType type) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.udtCodecs;
                synchronized (concurrentHashMap) {
                    Iterator it = MappingManager.this.udtCodecs.values().iterator();
                    while (it.hasNext()) {
                        MappedUDTCodec codec = (MappedUDTCodec)((Object)it.next());
                        if (!type.equals((Object)codec.getCqlType())) continue;
                        LOGGER.error("User type {} has been removed; existing mappers for @UDT annotated {} will not work anymore", (Object)type, codec.getUdtClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onUserTypeChanged(UserType current, UserType previous) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.udtCodecs;
                synchronized (concurrentHashMap) {
                    HashSet<MappedUDTCodec> deletedCodecs = new HashSet<MappedUDTCodec>();
                    Iterator it = MappingManager.this.udtCodecs.values().iterator();
                    while (it.hasNext()) {
                        MappedUDTCodec codec = (MappedUDTCodec)((Object)it.next());
                        if (!previous.equals((Object)codec.getCqlType())) continue;
                        LOGGER.warn("User type {} has been altered; existing mappers for @UDT annotated {} might not work properly anymore", (Object)previous, codec.getUdtClass());
                        deletedCodecs.add(codec);
                        it.remove();
                    }
                    for (MappedUDTCodec deletedCodec : deletedCodecs) {
                        try {
                            MappingManager.this.getUDTCodec(deletedCodec.getUdtClass());
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not update mapping for @UDT annotated " + deletedCodec.getUdtClass(), (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public Session getSession() {
        return this.session;
    }

    public MappingConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T> Mapper<T> mapper(Class<T> klass) {
        return this.getMapper(klass);
    }

    public <T> TypeCodec<T> udtCodec(Class<T> klass) {
        return this.getUDTCodec(klass);
    }

    public <T> T createAccessor(Class<T> klass) {
        return this.getAccessor(klass);
    }

    private <T> Mapper<T> getMapper(Class<T> klass) {
        EntityMapper<T> entityMapper;
        Mapper<?> old;
        Mapper<Object> mapper = this.mappers.get(klass);
        if (mapper == null && (old = this.mappers.putIfAbsent(klass, mapper = new Mapper<T>(this, klass, entityMapper = AnnotationParser.parseEntity(klass, this)))) != null) {
            mapper = old;
        }
        return mapper;
    }

    <T> TypeCodec<T> getUDTCodec(Class<T> mappedClass) {
        MappedUDTCodec<Object> codec = this.udtCodecs.get(mappedClass);
        if (codec == null) {
            codec = AnnotationParser.parseUDT(mappedClass, this);
            this.session.getCluster().getConfiguration().getCodecRegistry().register(codec);
            MappedUDTCodec<?> old = this.udtCodecs.putIfAbsent(mappedClass, codec);
            if (old != null) {
                codec = old;
            }
        }
        return codec;
    }

    private <T> T getAccessor(Class<T> klass) {
        Object accessor = this.accessors.get(klass);
        if (accessor == null) {
            AccessorMapper<T> mapper = AnnotationParser.parseAccessor(klass, this);
            mapper.prepare(this);
            accessor = mapper.createProxy();
            Object old = this.accessors.putIfAbsent(klass, accessor);
            if (old != null) {
                accessor = old;
            }
        }
        return (T)accessor;
    }
}

