/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

class QueryType {
    private final Kind kind;
    private final int startBoundSize;
    private final boolean startInclusive;
    private final int endBoundSize;
    private final boolean endInclusive;
    public static final QueryType SAVE = new QueryType(Kind.SAVE);
    public static final QueryType DEL = new QueryType(Kind.DEL);
    public static final QueryType GET = new QueryType(Kind.GET);

    private QueryType(Kind kind) {
        this(kind, 0, false, 0, false);
    }

    private QueryType(Kind kind, int startBoundSize, boolean startInclusive, int endBoundSize, boolean endInclusive) {
        this.kind = kind;
        this.startBoundSize = startBoundSize;
        this.startInclusive = startInclusive;
        this.endBoundSize = endBoundSize;
        this.endInclusive = endInclusive;
    }

    public static QueryType slice(int startBoundSize, boolean startInclusive, int endBoundSize, boolean endInclusive, boolean reversed) {
        return new QueryType(reversed ? Kind.REVERSED_SLICE : Kind.SLICE, startBoundSize, startInclusive, endBoundSize, endInclusive);
    }

    String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<ColumnMapper<?>> columns, Collection<Mapper.Option> options) {
        QueryBuilder builder = new QueryBuilder(manager.getSession().getCluster());
        switch (this.kind) {
            case SAVE: {
                Insert insert = table == null ? builder.insertInto(mapper.getKeyspace(), mapper.getTable()) : builder.insertInto(table);
                for (ColumnMapper<?> cm : columns) {
                    if (cm.kind == ColumnMapper.Kind.COMPUTED) continue;
                    insert.value(cm.getColumnName(), (Object)QueryBuilder.bindMarker());
                }
                Insert.Options usings = insert.using();
                for (Mapper.Option opt : options) {
                    opt.checkValidFor(SAVE, manager);
                    if (!opt.isIncludedInQuery()) continue;
                    opt.appendTo(usings);
                }
                return insert.toString();
            }
            case GET: {
                Select.Selection selection = builder.select();
                for (ColumnMapper<?> cm : mapper.allColumns()) {
                    Select.SelectionOrAlias column;
                    Select.SelectionOrAlias selectionOrAlias = column = cm.kind == ColumnMapper.Kind.COMPUTED ? ((Select.SelectionOrAlias)selection).raw(cm.getColumnName()) : selection.column(cm.getColumnName());
                    if (cm.getAlias() == null) {
                        selection = column;
                        continue;
                    }
                    selection = column.as(cm.getAlias());
                }
                Select select = table == null ? selection.from(mapper.getKeyspace(), mapper.getTable()) : selection.from(table);
                Select.Where where = select.where();
                for (int i = 0; i < mapper.primaryKeySize(); ++i) {
                    where.and(QueryBuilder.eq((String)mapper.getPrimaryKeyColumn(i).getColumnName(), (Object)QueryBuilder.bindMarker()));
                }
                for (Mapper.Option opt : options) {
                    opt.checkValidFor(GET, manager);
                }
                return select.toString();
            }
            case DEL: {
                Delete delete = table == null ? builder.delete().all().from(mapper.getKeyspace(), mapper.getTable()) : builder.delete().all().from(table);
                Delete.Where where = delete.where();
                for (int i = 0; i < mapper.primaryKeySize(); ++i) {
                    where.and(QueryBuilder.eq((String)mapper.getPrimaryKeyColumn(i).getColumnName(), (Object)QueryBuilder.bindMarker()));
                }
                Delete.Options usings = delete.using();
                for (Mapper.Option opt : options) {
                    opt.checkValidFor(DEL, manager);
                    if (!opt.isIncludedInQuery()) continue;
                    opt.appendTo(usings);
                }
                return delete.toString();
            }
            case SLICE: 
            case REVERSED_SLICE: {
                int i;
                ArrayList<BindMarker> values;
                Select select = table == null ? builder.select().all().from(mapper.getKeyspace(), mapper.getTable()) : builder.select().all().from(table);
                Select.Where where = select.where();
                for (int i2 = 0; i2 < mapper.partitionKeys.size(); ++i2) {
                    where.and(QueryBuilder.eq((String)mapper.partitionKeys.get(i2).getColumnName(), (Object)QueryBuilder.bindMarker()));
                }
                if (this.startBoundSize > 0) {
                    if (this.startBoundSize == 1) {
                        String name = mapper.clusteringColumns.get(0).getColumnName();
                        where.and(this.startInclusive ? QueryBuilder.gte((String)name, (Object)QueryBuilder.bindMarker()) : QueryBuilder.gt((String)name, (Object)QueryBuilder.bindMarker()));
                    } else {
                        ArrayList<String> names = new ArrayList<String>(this.startBoundSize);
                        values = new ArrayList<BindMarker>(this.startBoundSize);
                        for (i = 0; i < this.startBoundSize; ++i) {
                            names.add(mapper.clusteringColumns.get(i).getColumnName());
                            values.add(QueryBuilder.bindMarker());
                        }
                        where.and(this.startInclusive ? QueryBuilder.gte(names, values) : QueryBuilder.gt(names, values));
                    }
                }
                if (this.endBoundSize > 0) {
                    if (this.endBoundSize == 1) {
                        String name = mapper.clusteringColumns.get(0).getColumnName();
                        where.and(this.endInclusive ? QueryBuilder.gte((String)name, (Object)QueryBuilder.bindMarker()) : QueryBuilder.gt((String)name, (Object)QueryBuilder.bindMarker()));
                    } else {
                        ArrayList<String> names = new ArrayList<String>(this.endBoundSize);
                        values = new ArrayList(this.endBoundSize);
                        for (i = 0; i < this.endBoundSize; ++i) {
                            names.add(mapper.clusteringColumns.get(i).getColumnName());
                            values.add(QueryBuilder.bindMarker());
                        }
                        where.and(this.endInclusive ? QueryBuilder.lte(names, values) : QueryBuilder.lt(names, values));
                    }
                }
                select = select.limit(QueryBuilder.bindMarker());
                if (this.kind == Kind.REVERSED_SLICE) {
                    select = select.orderBy(new Ordering[]{QueryBuilder.desc((String)mapper.clusteringColumns.get(0).getColumnName())});
                }
                return select.toString();
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryType that = (QueryType)obj;
        return this.kind == that.kind && this.startBoundSize == that.startBoundSize && this.startInclusive == that.startInclusive && this.endBoundSize == that.endBoundSize && this.endInclusive == that.endInclusive;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.kind, this.startBoundSize, this.startInclusive, this.endBoundSize, this.endInclusive});
    }

    private static enum Kind {
        SAVE,
        GET,
        DEL,
        SLICE,
        REVERSED_SLICE;

    }
}

