/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.QueryType;
import com.datastax.driver.mapping.Result;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(EntityMapper.class);
    final MappingManager manager;
    final ProtocolVersion protocolVersion;
    final Class<T> klass;
    final EntityMapper<T> mapper;
    final TableMetadata tableMetadata;
    private volatile Map<MapperQueryKey, PreparedStatement> preparedQueries = Collections.emptyMap();
    private static final Function<Object, Void> NOOP = Functions.constant(null);
    private volatile EnumMap<Option.Type, Option> defaultSaveOptions;
    private volatile EnumMap<Option.Type, Option> defaultGetOptions;
    private volatile EnumMap<Option.Type, Option> defaultDeleteOptions;
    private static final EnumMap<Option.Type, Option> NO_OPTIONS = new EnumMap(Option.Type.class);
    final Function<ResultSet, T> mapOneFunction;
    final Function<ResultSet, T> mapOneFunctionWithoutAliases;
    final Function<ResultSet, Result<T>> mapAllFunctionWithoutAliases;

    Mapper(MappingManager manager, Class<T> klass, EntityMapper<T> mapper) {
        this.manager = manager;
        this.klass = klass;
        this.mapper = mapper;
        KeyspaceMetadata keyspace = this.session().getCluster().getMetadata().getKeyspace(mapper.getKeyspace());
        this.tableMetadata = keyspace == null ? null : keyspace.getTable(mapper.getTable());
        this.protocolVersion = manager.getSession().getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum();
        this.mapOneFunction = new Function<ResultSet, T>(){

            public T apply(ResultSet rs) {
                return Mapper.this.mapAliased(rs).one();
            }
        };
        this.mapOneFunctionWithoutAliases = new Function<ResultSet, T>(){

            public T apply(ResultSet rs) {
                return Mapper.this.map(rs).one();
            }
        };
        this.mapAllFunctionWithoutAliases = new Function<ResultSet, Result<T>>(){

            public Result<T> apply(ResultSet rs) {
                return Mapper.this.map(rs);
            }
        };
        this.defaultSaveOptions = NO_OPTIONS;
        this.defaultGetOptions = NO_OPTIONS;
        this.defaultDeleteOptions = NO_OPTIONS;
    }

    Session session() {
        return this.manager.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement getPreparedQuery(QueryType type, Set<ColumnMapper<?>> columns, EnumMap<Option.Type, Option> options) {
        MapperQueryKey pqk = new MapperQueryKey(type, columns, options);
        PreparedStatement stmt = this.preparedQueries.get(pqk);
        if (stmt == null) {
            Map<MapperQueryKey, PreparedStatement> map = this.preparedQueries;
            synchronized (map) {
                stmt = this.preparedQueries.get(pqk);
                if (stmt == null) {
                    String queryString = type.makePreparedQueryString(this.tableMetadata, this.mapper, this.manager, columns, options.values());
                    logger.debug("Preparing query {}", (Object)queryString);
                    stmt = this.session().prepare(queryString);
                    HashMap<MapperQueryKey, PreparedStatement> newQueries = new HashMap<MapperQueryKey, PreparedStatement>(this.preparedQueries);
                    newQueries.put(pqk, stmt);
                    this.preparedQueries = newQueries;
                }
            }
        }
        return stmt;
    }

    PreparedStatement getPreparedQuery(QueryType type, EnumMap<Option.Type, Option> options) {
        return this.getPreparedQuery(type, Collections.<ColumnMapper<?>>emptySet(), options);
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public MappingManager getManager() {
        return this.manager;
    }

    public Statement saveQuery(T entity) {
        return this.saveQuery(entity, this.defaultSaveOptions);
    }

    public Statement saveQuery(T entity, Option ... options) {
        return this.saveQuery(entity, Mapper.toMapWithDefaults(options, this.defaultSaveOptions));
    }

    private Statement saveQuery(T entity, EnumMap<Option.Type, Option> options) {
        HashMap<ColumnMapper<T>, Object> values = new HashMap<ColumnMapper<T>, Object>();
        boolean saveNullFields = Mapper.shouldSaveNullFields(options);
        for (ColumnMapper<T> cm : this.mapper.allColumns()) {
            Object value = cm.getValue(entity);
            if (cm.kind == ColumnMapper.Kind.COMPUTED || !saveNullFields && value == null) continue;
            values.put(cm, value);
        }
        BoundStatement bs = this.getPreparedQuery(QueryType.SAVE, values.keySet(), options).bind();
        int i = 0;
        for (Map.Entry entry : values.entrySet()) {
            DataType type = ((ColumnMapper)entry.getKey()).getDataType();
            Object value = entry.getValue();
            bs.setBytesUnsafe(i++, value == null ? null : type.serialize(value, this.protocolVersion));
        }
        if (this.mapper.writeConsistency != null) {
            bs.setConsistencyLevel(this.mapper.writeConsistency);
        }
        for (Option opt : options.values()) {
            opt.checkValidFor(QueryType.SAVE, this.manager);
            opt.addToPreparedStatement(bs, i++);
        }
        return bs;
    }

    private static boolean shouldSaveNullFields(EnumMap<Option.Type, Option> options) {
        Option.SaveNullFields option = (Option.SaveNullFields)options.get((Object)Option.Type.SAVE_NULL_FIELDS);
        return option == null || option.saveNullFields;
    }

    public void save(T entity) {
        this.session().execute(this.saveQuery(entity));
    }

    public void save(T entity, Option ... options) {
        this.session().execute(this.saveQuery(entity, options));
    }

    public ListenableFuture<Void> saveAsync(T entity) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.saveQuery(entity)), NOOP);
    }

    public ListenableFuture<Void> saveAsync(T entity, Option ... options) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.saveQuery(entity, options)), NOOP);
    }

    public Statement getQuery(Object ... objects) {
        ArrayList<Object> pks = new ArrayList<Object>();
        EnumMap<Option.Type, Option> options = new EnumMap<Option.Type, Option>(this.defaultGetOptions);
        for (Object o : objects) {
            if (o instanceof Option) {
                Option option = (Option)o;
                options.put(option.type, option);
                continue;
            }
            pks.add(o);
        }
        return this.getQuery(pks, options);
    }

    private Statement getQuery(List<Object> primaryKeys, EnumMap<Option.Type, Option> options) {
        if (primaryKeys.size() != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKeys.size()));
        }
        BoundStatement bs = this.getPreparedQuery(QueryType.GET, options).bind();
        int i = 0;
        for (Object value : primaryKeys) {
            ColumnMapper<T> column = this.mapper.getPrimaryKeyColumn(i);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.getColumnName(), i));
            }
            bs.setBytesUnsafe(i++, column.getDataType().serialize(value, this.protocolVersion));
        }
        if (this.mapper.readConsistency != null) {
            bs.setConsistencyLevel(this.mapper.readConsistency);
        }
        for (Option opt : options.values()) {
            opt.checkValidFor(QueryType.GET, this.manager);
            opt.addToPreparedStatement(bs, i);
            if (!opt.isIncludedInQuery()) continue;
            ++i;
        }
        return bs;
    }

    public T get(Object ... objects) {
        return this.mapAliased(this.session().execute(this.getQuery(objects))).one();
    }

    public ListenableFuture<T> getAsync(Object ... objects) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.getQuery(objects)), this.mapOneFunction);
    }

    public Statement deleteQuery(T entity, Option ... options) {
        ArrayList<Object> pks = new ArrayList<Object>();
        for (int i = 0; i < this.mapper.primaryKeySize(); ++i) {
            pks.add(this.mapper.getPrimaryKeyColumn(i).getValue(entity));
        }
        return this.deleteQuery(pks, Mapper.toMapWithDefaults(options, this.defaultDeleteOptions));
    }

    public Statement deleteQuery(T entity) {
        ArrayList<Object> pks = new ArrayList<Object>();
        for (int i = 0; i < this.mapper.primaryKeySize(); ++i) {
            pks.add(this.mapper.getPrimaryKeyColumn(i).getValue(entity));
        }
        return this.deleteQuery(pks, this.defaultDeleteOptions);
    }

    public Statement deleteQuery(Object ... objects) {
        ArrayList<Object> pks = new ArrayList<Object>();
        EnumMap<Option.Type, Option> options = new EnumMap<Option.Type, Option>(this.defaultDeleteOptions);
        for (Object o : objects) {
            if (o instanceof Option) {
                Option option = (Option)o;
                options.put(option.type, option);
                continue;
            }
            pks.add(o);
        }
        return this.deleteQuery(pks, options);
    }

    private Statement deleteQuery(List<Object> primaryKey, EnumMap<Option.Type, Option> options) {
        if (primaryKey.size() != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKey.size()));
        }
        BoundStatement bs = this.getPreparedQuery(QueryType.DEL, options).bind();
        if (this.mapper.writeConsistency != null) {
            bs.setConsistencyLevel(this.mapper.writeConsistency);
        }
        int i = 0;
        for (Option opt : options.values()) {
            opt.checkValidFor(QueryType.DEL, this.manager);
            opt.addToPreparedStatement(bs, i);
            if (!opt.isIncludedInQuery()) continue;
            ++i;
        }
        int columnNumber = 0;
        for (Object value : primaryKey) {
            ColumnMapper<T> column = this.mapper.getPrimaryKeyColumn(columnNumber);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.getColumnName(), i));
            }
            bs.setBytesUnsafe(i++, column.getDataType().serialize(value, this.protocolVersion));
            ++columnNumber;
        }
        return bs;
    }

    public void delete(T entity) {
        this.session().execute(this.deleteQuery(entity));
    }

    public void delete(T entity, Option ... options) {
        this.session().execute(this.deleteQuery(entity, options));
    }

    public ListenableFuture<Void> deleteAsync(T entity) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.deleteQuery(entity)), NOOP);
    }

    public ListenableFuture<Void> deleteAsync(T entity, Option ... options) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.deleteQuery(entity, options)), NOOP);
    }

    public void delete(Object ... objects) {
        this.session().execute(this.deleteQuery(objects));
    }

    public ListenableFuture<Void> deleteAsync(Object ... objects) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.deleteQuery(objects)), NOOP);
    }

    public Result<T> map(ResultSet resultSet) {
        return new Result<T>(resultSet, this.mapper, this.protocolVersion);
    }

    public Result<T> mapAliased(ResultSet resultSet) {
        return this.manager.isCassandraV1 ? this.map(resultSet) : new Result<T>(resultSet, this.mapper, this.protocolVersion, true);
    }

    public void setDefaultSaveOptions(Option ... options) {
        this.defaultSaveOptions = Mapper.toMap(options);
    }

    public void resetDefaultSaveOptions() {
        this.defaultSaveOptions = NO_OPTIONS;
    }

    public void setDefaultGetOptions(Option ... options) {
        this.defaultGetOptions = Mapper.toMap(options);
    }

    public void resetDefaultGetOptions() {
        this.defaultGetOptions = NO_OPTIONS;
    }

    public void setDefaultDeleteOptions(Option ... options) {
        this.defaultDeleteOptions = Mapper.toMap(options);
    }

    public void resetDefaultDeleteOptions() {
        this.defaultDeleteOptions = NO_OPTIONS;
    }

    private static EnumMap<Option.Type, Option> toMap(Option[] options) {
        EnumMap<Option.Type, Option> result = new EnumMap<Option.Type, Option>(Option.Type.class);
        for (Option option : options) {
            result.put(option.type, option);
        }
        return result;
    }

    private static EnumMap<Option.Type, Option> toMapWithDefaults(Option[] options, EnumMap<Option.Type, Option> defaults) {
        EnumMap<Option.Type, Option> result = new EnumMap<Option.Type, Option>(defaults);
        for (Option option : options) {
            result.put(option.type, option);
        }
        return result;
    }

    private static class MapperQueryKey {
        private final QueryType queryType;
        private final EnumSet<Option.Type> optionTypes;
        private final Set<ColumnMapper<?>> columns;

        MapperQueryKey(QueryType queryType, Set<ColumnMapper<?>> columnMappers, EnumMap<Option.Type, Option> options) {
            Preconditions.checkNotNull((Object)queryType);
            Preconditions.checkNotNull(options);
            Preconditions.checkNotNull(columnMappers);
            this.queryType = queryType;
            this.columns = columnMappers;
            this.optionTypes = EnumSet.noneOf(Option.Type.class);
            for (Option opt : options.values()) {
                if (!opt.isIncludedInQuery()) continue;
                this.optionTypes.add(opt.type);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof MapperQueryKey) {
                MapperQueryKey that = (MapperQueryKey)other;
                return this.queryType.equals(that.queryType) && this.optionTypes.equals(that.optionTypes) && this.columns.equals(that.columns);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.queryType, this.optionTypes, this.columns});
        }
    }

    public static abstract class Option {
        final Type type;

        protected Option(Type type) {
            this.type = type;
        }

        public static Option ttl(int ttl) {
            return new Ttl(ttl);
        }

        public static Option timestamp(long timestamp) {
            return new Timestamp(timestamp);
        }

        public static Option consistencyLevel(ConsistencyLevel cl) {
            return new ConsistencyLevelOption(cl);
        }

        public static Option tracing(boolean enabled) {
            return new Tracing(enabled);
        }

        public static Option saveNullFields(boolean enabled) {
            return new SaveNullFields(enabled);
        }

        public Type getType() {
            return this.type;
        }

        abstract void appendTo(Insert.Options var1);

        abstract void appendTo(Delete.Options var1);

        abstract void addToPreparedStatement(BoundStatement var1, int var2);

        abstract void checkValidFor(QueryType var1, MappingManager var2) throws IllegalArgumentException;

        abstract boolean isIncludedInQuery();

        static class SaveNullFields
        extends Option {
            private boolean saveNullFields;

            SaveNullFields(boolean saveNullFields) {
                super(Type.SAVE_NULL_FIELDS);
                this.saveNullFields = saveNullFields;
            }

            @Override
            void appendTo(Insert.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((qt == QueryType.SAVE ? 1 : 0) != 0, (Object)"SaveNullFields option is only allowed in save queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return false;
            }
        }

        static class Tracing
        extends Option {
            private boolean tracing;

            Tracing(boolean tracing) {
                super(Type.TRACING);
                this.tracing = tracing;
            }

            @Override
            void appendTo(Insert.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                if (this.tracing) {
                    bs.enableTracing();
                }
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((qt == QueryType.SAVE || qt == QueryType.DEL || qt == QueryType.GET ? 1 : 0) != 0, (Object)"Tracing option is only allowed in save, delete and get queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return false;
            }
        }

        static class ConsistencyLevelOption
        extends Option {
            private ConsistencyLevel cl;

            ConsistencyLevelOption(ConsistencyLevel cl) {
                super(Type.CL);
                this.cl = cl;
            }

            @Override
            void appendTo(Insert.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                bs.setConsistencyLevel(this.cl);
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((qt == QueryType.SAVE || qt == QueryType.DEL || qt == QueryType.GET ? 1 : 0) != 0, (Object)"Consistency level option is only allowed in save, delete and get queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return false;
            }
        }

        static class Timestamp
        extends Option {
            private long tsValue;

            Timestamp(long value) {
                super(Type.TIMESTAMP);
                this.tsValue = value;
            }

            @Override
            void appendTo(Insert.Options usings) {
                usings.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
            }

            @Override
            void appendTo(Delete.Options usings) {
                usings.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((!manager.isCassandraV1 ? 1 : 0) != 0, (Object)"Timestamp option requires native protocol v2 or above");
                Preconditions.checkArgument((qt == QueryType.SAVE || qt == QueryType.DEL ? 1 : 0) != 0, (Object)"Timestamp option is only allowed in save and delete queries");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                bs.setLong(i, this.tsValue);
            }

            @Override
            boolean isIncludedInQuery() {
                return true;
            }
        }

        static class Ttl
        extends Option {
            private int ttlValue;

            Ttl(int value) {
                super(Type.TTL);
                this.ttlValue = value;
            }

            @Override
            void appendTo(Insert.Options usings) {
                usings.and(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker()));
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                bs.setInt(i, this.ttlValue);
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((!manager.isCassandraV1 ? 1 : 0) != 0, (Object)"TTL option requires native protocol v2 or above");
                Preconditions.checkArgument((qt == QueryType.SAVE ? 1 : 0) != 0, (Object)"TTL option is only allowed in save queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return true;
            }
        }

        static enum Type {
            TTL,
            TIMESTAMP,
            CL,
            TRACING,
            SAVE_NULL_FIELDS;

        }
    }
}

