/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.mapping.annotations.UDT;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class TypeMappings {
    TypeMappings() {
    }

    static DataType getSimpleType(Class<?> klass, String fieldName) {
        if (ByteBuffer.class.isAssignableFrom(klass)) {
            return DataType.blob();
        }
        if (klass == Integer.TYPE || Integer.class.isAssignableFrom(klass)) {
            return DataType.cint();
        }
        if (klass == Long.TYPE || Long.class.isAssignableFrom(klass)) {
            return DataType.bigint();
        }
        if (klass == Float.TYPE || Float.class.isAssignableFrom(klass)) {
            return DataType.cfloat();
        }
        if (klass == Double.TYPE || Double.class.isAssignableFrom(klass)) {
            return DataType.cdouble();
        }
        if (klass == Boolean.TYPE || Boolean.class.isAssignableFrom(klass)) {
            return DataType.cboolean();
        }
        if (BigDecimal.class.isAssignableFrom(klass)) {
            return DataType.decimal();
        }
        if (BigInteger.class.isAssignableFrom(klass)) {
            return DataType.varint();
        }
        if (String.class.isAssignableFrom(klass)) {
            return DataType.text();
        }
        if (InetAddress.class.isAssignableFrom(klass)) {
            return DataType.inet();
        }
        if (Date.class.isAssignableFrom(klass)) {
            return DataType.timestamp();
        }
        if (UUID.class.isAssignableFrom(klass)) {
            return DataType.uuid();
        }
        if (Collection.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException(String.format("Cannot map non-parametrized collection type %s for field %s; Please use a concrete type parameter", klass.getName(), fieldName));
        }
        throw new IllegalArgumentException(String.format("Cannot map unknown class %s for field %s", klass.getName(), fieldName));
    }

    static boolean mapsToList(Class<?> klass) {
        return List.class.equals(klass);
    }

    static boolean mapsToSet(Class<?> klass) {
        return Set.class.equals(klass);
    }

    static boolean mapsToMap(Class<?> klass) {
        return Map.class.equals(klass);
    }

    static boolean mapsToCollection(Class<?> klass) {
        return TypeMappings.mapsToList(klass) || TypeMappings.mapsToSet(klass) || TypeMappings.mapsToMap(klass);
    }

    static boolean isMappedUDT(Class<?> klass) {
        return klass.isAnnotationPresent(UDT.class);
    }

    static boolean mapsToUserTypeOrTuple(Class<?> klass) {
        return TypeMappings.isMappedUDT(klass) || klass.equals(UDTValue.class) || klass.equals(TupleValue.class);
    }
}

