/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.AccessorReflectionMapper;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.ReflectionMapper;
import com.datastax.driver.mapping.UDTMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MappingManager {
    private final Session session;
    private volatile Map<Class<?>, Mapper<?>> mappers = Collections.emptyMap();
    private volatile Map<Class<?>, UDTMapper<?>> udtMappers = Collections.emptyMap();
    private volatile Map<Class<?>, Object> accessors = Collections.emptyMap();

    public MappingManager(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public <T> Mapper<T> mapper(Class<T> klass) {
        return this.getMapper(klass);
    }

    public <T> UDTMapper<T> udtMapper(Class<T> klass) {
        return this.getUDTMapper(klass);
    }

    public <T> T createAccessor(Class<T> klass) {
        return this.getAccessor(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Mapper<T> getMapper(Class<T> klass) {
        Mapper<Object> mapper = this.mappers.get(klass);
        if (mapper == null) {
            Map<Class<?>, Mapper<?>> map = this.mappers;
            synchronized (map) {
                mapper = this.mappers.get(klass);
                if (mapper == null) {
                    EntityMapper<T> entityMapper = AnnotationParser.parseEntity(klass, ReflectionMapper.factory(), this);
                    mapper = new Mapper<T>(this, klass, entityMapper);
                    HashMap newMappers = new HashMap(this.mappers);
                    newMappers.put(klass, mapper);
                    this.mappers = newMappers;
                }
            }
        }
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> UDTMapper<T> getUDTMapper(Class<T> klass) {
        UDTMapper<Object> mapper = this.udtMappers.get(klass);
        if (mapper == null) {
            Map<Class<?>, UDTMapper<?>> map = this.udtMappers;
            synchronized (map) {
                mapper = this.udtMappers.get(klass);
                if (mapper == null) {
                    EntityMapper<T> entityMapper = AnnotationParser.parseUDT(klass, ReflectionMapper.factory(), this);
                    mapper = new UDTMapper<T>(entityMapper, this.session);
                    HashMap newMappers = new HashMap(this.udtMappers);
                    newMappers.put(klass, mapper);
                    this.udtMappers = newMappers;
                }
            }
        }
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getAccessor(Class<T> klass) {
        Object accessor = this.accessors.get(klass);
        if (accessor == null) {
            Map<Class<?>, Object> map = this.accessors;
            synchronized (map) {
                accessor = this.accessors.get(klass);
                if (accessor == null) {
                    AccessorMapper<T> mapper = AnnotationParser.parseAccessor(klass, AccessorReflectionMapper.factory(), this);
                    mapper.prepare(this);
                    accessor = mapper.createProxy();
                    HashMap newAccessors = new HashMap(this.accessors);
                    newAccessors.put(klass, accessor);
                    this.accessors = newAccessors;
                }
            }
        }
        return (T)accessor;
    }
}

