/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.QueryType;
import com.datastax.driver.mapping.Result;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(EntityMapper.class);
    final MappingManager manager;
    final ProtocolVersion protocolVersion;
    final Class<T> klass;
    final EntityMapper<T> mapper;
    final TableMetadata tableMetadata;
    private volatile Map<QueryType, PreparedStatement> preparedQueries = Collections.emptyMap();
    private static final Function<Object, Void> NOOP = Functions.constant(null);
    final Function<ResultSet, T> mapOneFunction;
    final Function<ResultSet, Result<T>> mapAllFunction;

    Mapper(MappingManager manager, Class<T> klass, EntityMapper<T> mapper) {
        this.manager = manager;
        this.klass = klass;
        this.mapper = mapper;
        KeyspaceMetadata keyspace = this.session().getCluster().getMetadata().getKeyspace(mapper.getKeyspace());
        this.tableMetadata = keyspace == null ? null : keyspace.getTable(Metadata.quote((String)mapper.getTable()));
        this.protocolVersion = manager.getSession().getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum();
        this.mapOneFunction = new Function<ResultSet, T>(){

            public T apply(ResultSet rs) {
                return Mapper.this.map(rs).one();
            }
        };
        this.mapAllFunction = new Function<ResultSet, Result<T>>(){

            public Result<T> apply(ResultSet rs) {
                return Mapper.this.map(rs);
            }
        };
    }

    Session session() {
        return this.manager.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement getPreparedQuery(QueryType type) {
        PreparedStatement stmt = this.preparedQueries.get(type);
        if (stmt == null) {
            Map<QueryType, PreparedStatement> map = this.preparedQueries;
            synchronized (map) {
                stmt = this.preparedQueries.get(type);
                if (stmt == null) {
                    String query = type.makePreparedQueryString(this.tableMetadata, this.mapper);
                    logger.debug("Preparing query {}", (Object)query);
                    stmt = this.session().prepare(query);
                    HashMap<QueryType, PreparedStatement> newQueries = new HashMap<QueryType, PreparedStatement>(this.preparedQueries);
                    newQueries.put(type, stmt);
                    this.preparedQueries = newQueries;
                }
            }
        }
        return stmt;
    }

    public MappingManager getManager() {
        return this.manager;
    }

    public Statement saveQuery(T entity) {
        PreparedStatement ps = this.getPreparedQuery(QueryType.SAVE);
        BoundStatement bs = ps.bind();
        int i = 0;
        for (ColumnMapper<T> cm : this.mapper.allColumns()) {
            Object value = cm.getValue(entity);
            bs.setBytesUnsafe(i++, value == null ? null : cm.getDataType().serialize(value, this.protocolVersion));
        }
        if (this.mapper.writeConsistency != null) {
            bs.setConsistencyLevel(this.mapper.writeConsistency);
        }
        return bs;
    }

    public void save(T entity) {
        this.session().execute(this.saveQuery(entity));
    }

    public ListenableFuture<Void> saveAsync(T entity) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.saveQuery(entity)), NOOP);
    }

    public Statement deleteQuery(T entity) {
        Object[] pks = new Object[this.mapper.primaryKeySize()];
        for (int i = 0; i < pks.length; ++i) {
            pks[i] = this.mapper.getPrimaryKeyColumn(i).getValue(entity);
        }
        return this.deleteQuery(pks);
    }

    public Statement deleteQuery(Object ... primaryKey) {
        if (primaryKey.length != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKey.length));
        }
        PreparedStatement ps = this.getPreparedQuery(QueryType.DEL);
        BoundStatement bs = ps.bind();
        for (int i = 0; i < primaryKey.length; ++i) {
            ColumnMapper<T> column = this.mapper.getPrimaryKeyColumn(i);
            Object value = primaryKey[i];
            if (value == null) {
                throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.getColumnName(), i));
            }
            bs.setBytesUnsafe(i, column.getDataType().serialize(value, this.protocolVersion));
        }
        if (this.mapper.writeConsistency != null) {
            bs.setConsistencyLevel(this.mapper.writeConsistency);
        }
        return bs;
    }

    public void delete(T entity) {
        this.session().execute(this.deleteQuery(entity));
    }

    public ListenableFuture<Void> deleteAsync(T entity) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.deleteQuery(entity)), NOOP);
    }

    public void delete(Object ... primaryKey) {
        this.session().execute(this.deleteQuery(primaryKey));
    }

    public ListenableFuture<Void> deleteAsync(Object ... primaryKey) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.deleteQuery(primaryKey)), NOOP);
    }

    public Result<T> map(ResultSet resultSet) {
        return new Result<T>(resultSet, this.mapper, this.protocolVersion);
    }

    public Statement getQuery(Object ... primaryKey) {
        if (primaryKey.length != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKey.length));
        }
        PreparedStatement ps = this.getPreparedQuery(QueryType.GET);
        BoundStatement bs = ps.bind();
        for (int i = 0; i < primaryKey.length; ++i) {
            ColumnMapper<T> column = this.mapper.getPrimaryKeyColumn(i);
            Object value = primaryKey[i];
            if (value == null) {
                throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.getColumnName(), i));
            }
            bs.setBytesUnsafe(i, column.getDataType().serialize(value, this.protocolVersion));
        }
        if (this.mapper.readConsistency != null) {
            bs.setConsistencyLevel(this.mapper.readConsistency);
        }
        return bs;
    }

    public T get(Object ... primaryKey) {
        return this.map(this.session().execute(this.getQuery(primaryKey))).one();
    }

    public ListenableFuture<T> getAsync(Object ... primaryKey) {
        return Futures.transform((ListenableFuture)this.session().executeAsync(this.getQuery(primaryKey)), this.mapOneFunction);
    }
}

