/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;

class CQLType {
    String name;
    boolean frozen;
    List<CQLType> subTypes;
    static final CQLType FROZEN_SIMPLE = new CQLType("root", true, new CQLType[0]);
    static final CQLType FROZEN_ELEMENT = new CQLType("collection", false, new CQLType("element", true, new CQLType[0]));
    static final CQLType FROZEN_MAP_KEY = new CQLType("map", false, new CQLType("key", true, new CQLType[0]));
    static final CQLType FROZEN_MAP_VALUE = new CQLType("map", false, new CQLType("key", false, new CQLType[0]), new CQLType("value", true, new CQLType[0]));
    static final CQLType FROZEN_MAP_KEY_AND_VALUE = new CQLType("map", false, new CQLType("key", true, new CQLType[0]), new CQLType("value", true, new CQLType[0]));
    static final CQLType UNFROZEN_SIMPLE = new CQLType("root");

    private CQLType(String name) {
        this(name, false, new CQLType[0]);
    }

    private CQLType(String name, boolean frozen, CQLType ... subTypes) {
        this.name = name;
        this.frozen = frozen;
        for (CQLType subType : subTypes) {
            if (this.subTypes == null) {
                this.subTypes = new ArrayList<CQLType>();
            }
            this.subTypes.add(subType);
        }
    }

    static CQLType parse(String toParse) {
        if (Strings.isNullOrEmpty((String)toParse)) {
            return FROZEN_SIMPLE;
        }
        return new Parser(toParse).parse();
    }

    private static class Parser {
        private final String toParse;
        private int idx;

        Parser(String toParse) {
            this.toParse = toParse;
        }

        CQLType parse() {
            this.skipSpaces();
            if (this.toParse.charAt(this.idx) == '\"') {
                int endQuote;
                for (endQuote = this.idx + 1; endQuote < this.toParse.length() && this.toParse.charAt(endQuote) != '\"'; ++endQuote) {
                }
                if (endQuote == this.toParse.length()) {
                    throw this.fail("could not find matching quote");
                }
                if (endQuote == this.idx + 1) {
                    throw this.fail("empty quoted identifier");
                }
                String name = this.toParse.substring(this.idx + 1, endQuote);
                this.idx = endQuote + 1;
                return new CQLType(name);
            }
            int n = this.skipWord();
            String nextWord = this.toParse.substring(this.idx, n).toLowerCase();
            this.idx = n;
            if ("frozen".equals(nextWord)) {
                this.skipSpaces();
                if (this.idx >= this.toParse.length() || this.toParse.charAt(this.idx) != '<') {
                    throw this.fail("expected '<'");
                }
                ++this.idx;
                CQLType type = this.parse();
                this.skipSpaces();
                if (this.idx >= this.toParse.length() || this.toParse.charAt(this.idx) != '>') {
                    throw this.fail("expected '>'");
                }
                ++this.idx;
                type.frozen = true;
                return type;
            }
            CQLType type = new CQLType(nextWord);
            this.skipSpaces();
            if (this.idx < this.toParse.length() && this.toParse.charAt(this.idx) == '<') {
                ++this.idx;
                type.subTypes = new ArrayList<CQLType>();
                while (this.idx < this.toParse.length()) {
                    type.subTypes.add(this.parse());
                    this.skipSpaces();
                    if (this.idx >= this.toParse.length()) {
                        this.fail("unterminated list of subtypes");
                        continue;
                    }
                    if (this.toParse.charAt(this.idx) == '>') {
                        ++this.idx;
                        break;
                    }
                    if (this.toParse.charAt(this.idx) != ',') {
                        this.fail("expected ','");
                        continue;
                    }
                    ++this.idx;
                }
            }
            return type;
        }

        private void skipSpaces() {
            while (this.idx < this.toParse.length() && this.isBlank(this.idx)) {
                ++this.idx;
            }
        }

        private int skipWord() {
            int i;
            if (this.idx >= this.toParse.length()) {
                throw this.fail("expected type name");
            }
            if (!this.isIdentStart(this.idx)) {
                throw this.fail("illegal character at start of type name");
            }
            for (i = this.idx; i < this.toParse.length() && this.isIdentBody(i); ++i) {
            }
            return i;
        }

        private boolean isBlank(int i) {
            char c = this.toParse.charAt(i);
            return c == ' ' || c == '\t' || c == '\n';
        }

        private boolean isIdentStart(int i) {
            char c = this.toParse.charAt(i);
            return this.isLetter(c);
        }

        private boolean isIdentBody(int i) {
            char c = this.toParse.charAt(i);
            return this.isLetter(c) || this.isDigit(c) || c == '_';
        }

        private boolean isLetter(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        private boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private IllegalArgumentException fail(String cause) {
            return new IllegalArgumentException(cause + " (" + this.toParse + " [" + this.idx + "])");
        }
    }
}

