/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UDTMapper<T> {
    private static final int UDT_PROTOCOL_VERSION = Math.max(2, 3);
    private final EntityMapper<T> entityMapper;
    private final UserType userType;

    UDTMapper(EntityMapper<T> entityMapper, Session session) {
        this.entityMapper = entityMapper;
        String keyspace = entityMapper.getKeyspace();
        String udt = entityMapper.getTable();
        this.userType = session.getCluster().getMetadata().getKeyspace(keyspace).getUserType(udt);
        if (this.userType == null) {
            throw new IllegalArgumentException(String.format("Type \"%s\" does not exist in keyspace \"%s\"", udt, keyspace));
        }
    }

    public T fromUDT(UDTValue v) {
        if (!v.getType().equals((Object)this.userType)) {
            String message = String.format("UDT conversion mismatch: expected type %s, got %s", this.userType, v.getType());
            throw new IllegalArgumentException(message);
        }
        return this.toEntity(v);
    }

    public UDTValue toUDT(T entity) {
        UDTValue udtValue = this.userType.newValue();
        for (ColumnMapper<T> cm : this.entityMapper.allColumns()) {
            Object value = cm.getValue(entity);
            udtValue.setBytesUnsafe(cm.getColumnName(), value == null ? null : cm.getDataType().serialize(value, UDT_PROTOCOL_VERSION));
        }
        return udtValue;
    }

    UserType getUserType() {
        return this.userType;
    }

    List<UDTValue> toUDTValues(List<T> entities) {
        ArrayList<UDTValue> udtValues = new ArrayList<UDTValue>(entities.size());
        for (T entity : entities) {
            UDTValue udtValue = this.toUDT(entity);
            udtValues.add(udtValue);
        }
        return udtValues;
    }

    Set<UDTValue> toUDTValues(Set<T> entities) {
        HashSet udtValues = Sets.newHashSetWithExpectedSize((int)entities.size());
        for (T entity : entities) {
            UDTValue udtValue = this.toUDT(entity);
            udtValues.add(udtValue);
        }
        return udtValues;
    }

    static <K, V> Map<Object, Object> toUDTValues(Map<K, V> entities, UDTMapper<K> keyMapper, UDTMapper<V> valueMapper) {
        assert (keyMapper != null || valueMapper != null);
        HashMap udtValues = Maps.newHashMapWithExpectedSize((int)entities.size());
        for (Map.Entry<K, V> entry : entities.entrySet()) {
            K key = keyMapper == null ? entry.getKey() : keyMapper.toUDT(entry.getKey());
            V value = valueMapper == null ? entry.getValue() : valueMapper.toUDT(entry.getValue());
            udtValues.put(key, value);
        }
        return udtValues;
    }

    T toEntity(UDTValue udtValue) {
        T entity = this.entityMapper.newEntity();
        for (ColumnMapper<T> cm : this.entityMapper.allColumns()) {
            ByteBuffer bytes = udtValue.getBytesUnsafe(cm.getColumnName());
            if (bytes == null) continue;
            cm.setValue(entity, cm.getDataType().deserialize(bytes, UDT_PROTOCOL_VERSION));
        }
        return entity;
    }

    List<T> toEntities(List<UDTValue> udtValues) {
        ArrayList<T> entities = new ArrayList<T>(udtValues.size());
        for (UDTValue udtValue : udtValues) {
            entities.add(this.toEntity(udtValue));
        }
        return entities;
    }

    Set<T> toEntities(Set<UDTValue> udtValues) {
        HashSet entities = Sets.newHashSetWithExpectedSize((int)udtValues.size());
        for (UDTValue udtValue : udtValues) {
            entities.add(this.toEntity(udtValue));
        }
        return entities;
    }

    static <K, V> Map<K, V> toEntities(Map<Object, Object> udtValues, UDTMapper<K> keyMapper, UDTMapper<V> valueMapper) {
        HashMap entities = Maps.newHashMapWithExpectedSize((int)udtValues.size());
        for (Map.Entry<Object, Object> entry : udtValues.entrySet()) {
            Object key = keyMapper == null ? entry.getKey() : keyMapper.toEntity((UDTValue)entry.getKey());
            Object value = valueMapper == null ? entry.getValue() : valueMapper.toEntity((UDTValue)entry.getValue());
            entities.put(key, value);
        }
        return entities;
    }
}

