/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.mapping.CQLType;
import com.datastax.driver.mapping.annotations.Frozen;
import com.datastax.driver.mapping.annotations.FrozenKey;
import com.datastax.driver.mapping.annotations.FrozenValue;
import com.datastax.driver.mapping.annotations.Table;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AnnotationChecks {
    private static final Package MAPPING_PACKAGE = Table.class.getPackage();
    private static final Set<Class<?>> EXPECTED_NON_FROZEN_CLASSES;

    AnnotationChecks() {
    }

    static <T extends Annotation> T getTypeAnnotation(Class<T> annotation, Class<?> annotatedClass) {
        T instance = annotatedClass.getAnnotation(annotation);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("@%s annotation was not found on type %s", annotation.getSimpleName(), annotatedClass.getName()));
        }
        AnnotationChecks.validateAnnotations(annotatedClass, annotation);
        return instance;
    }

    private static void validateAnnotations(Class<?> clazz, Class<? extends Annotation> allowed) {
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(clazz.getAnnotations(), allowed);
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Cannot have both @%s and @%s on type %s", allowed.getSimpleName(), invalid.getSimpleName(), clazz.getName()));
        }
    }

    static void validateAnnotations(Field field, String classDescription, Class<? extends Annotation> ... allowed) {
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(field.getAnnotations(), allowed);
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Annotation @%s is not allowed on field %s of %s %s", invalid.getSimpleName(), field.getName(), classDescription, field.getDeclaringClass().getName()));
        }
        try {
            AnnotationChecks.checkFrozenTypes(field);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Error while checking frozen types on field %s of %s %s: %s", field.getName(), classDescription, field.getDeclaringClass().getName(), e.getMessage()));
        }
    }

    private static Class<? extends Annotation> validateAnnotations(Annotation[] annotations, Class<? extends Annotation> ... allowed) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> actual = annotation.annotationType();
            if (!actual.getPackage().equals(MAPPING_PACKAGE) || AnnotationChecks.contains(allowed, actual)) continue;
            return actual;
        }
        return null;
    }

    private static boolean contains(Object[] array, Object target) {
        for (Object element : array) {
            if (!element.equals(target)) continue;
            return true;
        }
        return false;
    }

    static void checkFrozenTypes(Field field) {
        Type javaType = field.getGenericType();
        CQLType cqlType = AnnotationChecks.getCQLType(field);
        AnnotationChecks.checkFrozenTypes(javaType, cqlType);
    }

    private static CQLType getCQLType(Field field) {
        boolean frozenValue;
        Frozen frozen = field.getAnnotation(Frozen.class);
        if (frozen != null) {
            return CQLType.parse(frozen.value());
        }
        boolean frozenKey = field.getAnnotation(FrozenKey.class) != null;
        boolean bl = frozenValue = field.getAnnotation(FrozenValue.class) != null;
        if (frozenKey && frozenValue) {
            return CQLType.FROZEN_MAP_KEY_AND_VALUE;
        }
        if (frozenKey) {
            return CQLType.FROZEN_MAP_KEY;
        }
        if (frozenValue && field.getType().equals(Map.class)) {
            return CQLType.FROZEN_MAP_VALUE;
        }
        if (frozenValue) {
            return CQLType.FROZEN_ELEMENT;
        }
        return CQLType.UNFROZEN_SIMPLE;
    }

    private static void checkFrozenTypes(Type javaType, CQLType cqlType) {
        Type[] childrenJavaTypes;
        Class javaClass;
        if (javaType instanceof Class) {
            javaClass = (Class)javaType;
            childrenJavaTypes = null;
        } else if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            javaClass = (Class)pt.getRawType();
            childrenJavaTypes = pt.getActualTypeArguments();
        } else {
            throw new IllegalArgumentException("unexpected type: " + javaType);
        }
        boolean frozen = cqlType != null && cqlType.frozen;
        AnnotationChecks.checkValidFrozen(javaClass, frozen);
        if (childrenJavaTypes != null) {
            for (int i = 0; i < childrenJavaTypes.length; ++i) {
                Type childJavaType = childrenJavaTypes[i];
                CQLType childCQLType = null;
                if (cqlType != null && cqlType.subTypes != null && cqlType.subTypes.size() > i) {
                    childCQLType = cqlType.subTypes.get(i);
                }
                AnnotationChecks.checkFrozenTypes(childJavaType, childCQLType);
            }
        }
    }

    private static void checkValidFrozen(Class<?> clazz, boolean declared) {
        boolean expected;
        boolean bl = expected = !EXPECTED_NON_FROZEN_CLASSES.contains(clazz) && !clazz.isEnum();
        if (expected != declared) {
            throw new IllegalArgumentException(String.format("expected %s to be %sfrozen but was %sfrozen", clazz.getSimpleName(), expected ? "" : "not ", declared ? "" : "not "));
        }
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DataType type : DataType.allPrimitiveTypes()) {
            builder.add((Object)type.asJavaClass());
            builder.add((Object)Primitives.unwrap((Class)type.asJavaClass()));
        }
        builder.add(List.class);
        builder.add(Set.class);
        builder.add(Map.class);
        EXPECTED_NON_FROZEN_CLASSES = builder.build();
    }
}

