/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.time;

import com.datasqrl.time.TimeTumbleWindowFunction;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;

public class EndOfMonth
extends TimeTumbleWindowFunction {
    public EndOfMonth() {
        super(ChronoUnit.MONTHS, ChronoUnit.DAYS);
    }

    @Override
    public Instant eval(Instant instant, Long multiple, Long offset) {
        ZonedDateTime time;
        if (multiple == null) {
            multiple = 1L;
        }
        if (offset == null) {
            offset = 0L;
        }
        time = (long)(time = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC).truncatedTo(ChronoUnit.DAYS)).getDayOfMonth() > offset ? time.with(TemporalAdjusters.firstDayOfNextMonth()) : time.with(TemporalAdjusters.firstDayOfMonth());
        time = time.plusDays(offset);
        return time.minusNanos(1L).toInstant();
    }
}

