/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.FlinkJsonType;
import com.datasqrl.json.FlinkJsonTypeSerializer;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class FlinkJsonTypeSerializerSnapshot
implements TypeSerializerSnapshot<FlinkJsonType> {
    private Class<FlinkJsonTypeSerializer> serializerClass = FlinkJsonTypeSerializer.class;

    public int getCurrentVersion() {
        return 1;
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        out.writeUTF(FlinkJsonTypeSerializer.class.getName());
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        String className = in.readUTF();
        try {
            this.serializerClass = Class.forName(className, true, userCodeClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to find serializer class: " + className, e);
        }
    }

    public TypeSerializer restoreSerializer() {
        try {
            return this.serializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate serializer class: " + this.serializerClass.getName(), e);
        }
    }

    public TypeSerializerSchemaCompatibility resolveSchemaCompatibility(TypeSerializer newSerializer) {
        if (newSerializer.getClass() == this.serializerClass) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }
}

