/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import java.util.logging.Level;

public enum LogLevel {
    OFF(0, "OFF"),
    ERROR(1, "ERROR"),
    WARN(2, "WARN"),
    INFO(3, "INFO"),
    DEBUG(4, "DEBUG"),
    TRACE(5, "TRACE"),
    ALL(6, "ALL");

    private int level;
    private String label;

    private LogLevel(int level, String label) {
        this.level = level;
        this.label = label;
    }

    public static LogLevel fromJulLevel(Level julLevel) {
        if (julLevel == Level.ALL) {
            return ALL;
        }
        if (julLevel == Level.SEVERE) {
            return ERROR;
        }
        if (julLevel == Level.WARNING) {
            return WARN;
        }
        if (julLevel == Level.INFO) {
            return INFO;
        }
        if (julLevel == Level.CONFIG) {
            return DEBUG;
        }
        if (julLevel == Level.FINE) {
            return DEBUG;
        }
        if (julLevel == Level.FINER) {
            return TRACE;
        }
        if (julLevel == Level.FINEST) {
            return TRACE;
        }
        if (julLevel == Level.OFF) {
            return OFF;
        }
        return INFO;
    }

    public static LogLevel fromString(String str) {
        if (str.toUpperCase().equals("FATAL")) {
            return ERROR;
        }
        for (LogLevel l : (LogLevel[])LogLevel.class.getEnumConstants()) {
            if (!str.toUpperCase().equals(l.toString().toUpperCase())) continue;
            return l;
        }
        return INFO;
    }

    public Level toJulLevel() {
        switch (this) {
            case ALL: {
                return Level.ALL;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case WARN: {
                return Level.WARNING;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case TRACE: {
                return Level.FINEST;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        return Level.INFO;
    }
}

