/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.TabularData;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JmxSubAttribute;
import org.datadog.jmxfetch.Metric;
import org.datadog.jmxfetch.service.ServiceNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTabularAttribute
extends JmxSubAttribute {
    private static final Logger log = LoggerFactory.getLogger(JmxTabularAttribute.class);
    private String instanceName;
    private Map<String, List<String>> subAttributeList = new HashMap<String, List<String>>();

    public JmxTabularAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String className, String instanceName, String checkName, Connection connection, ServiceNameProvider serviceNameProvider, Map<String, String> instanceTags, boolean emptyDefaultHostname, boolean normalizeBeanParamTags) {
        super(attribute, beanName, className, instanceName, checkName, connection, serviceNameProvider, instanceTags, false, emptyDefaultHostname, normalizeBeanParamTags);
    }

    private String getMultiKey(Collection keys) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object key : keys) {
            if (!first) {
                sb.append(",");
            }
            sb.append(key.toString());
            first = false;
        }
        return sb.toString();
    }

    private void populateSubAttributeList(Object value) {
        TabularData data = (TabularData)value;
        for (Object rowKey : data.keySet()) {
            Collection keys = (Collection)rowKey;
            CompositeData compositeData = data.get(keys.toArray());
            String pathKey = this.getMultiKey(keys);
            ArrayList<String> subAttributes = new ArrayList<String>();
            for (String key : compositeData.getCompositeType().keySet()) {
                if (compositeData.get(key) instanceof CompositeData) {
                    for (String subKey : ((CompositeData)compositeData.get(key)).getCompositeType().keySet()) {
                        subAttributes.add(key + "." + subKey);
                    }
                    continue;
                }
                subAttributes.add(key);
            }
            this.subAttributeList.put(pathKey, subAttributes);
        }
    }

    protected String[] getTags(String key, String subAttribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Map yamlTags;
        ArrayList<String> tagsList = new ArrayList<String>();
        String fullMetricKey = this.getAttributeName() + "." + subAttribute;
        Map<String, ?> attributeParams = this.getAttributesFor(fullMetricKey);
        if (attributeParams != null && (yamlTags = (Map)attributeParams.get("tags")) != null) {
            Iterator iterator = yamlTags.keySet().iterator();
            while (iterator.hasNext()) {
                Object resolvedValue;
                String tagName;
                String tag = tagName = (String)iterator.next();
                String value = (String)yamlTags.get(tagName);
                if (value.startsWith("$") && (resolvedValue = this.getValue(key, value.substring(1))) != null) {
                    value = (String)resolvedValue;
                }
                tagsList.add(tag + ":" + value);
            }
        }
        String[] defaultTags = super.getTags();
        tagsList.addAll(Arrays.asList(defaultTags));
        String[] tags = new String[tagsList.size()];
        tags = tagsList.toArray(tags);
        return tags;
    }

    private Map<String, ?> getAttributesFor(String key) {
        Object includeAttribute;
        Filter include = this.getMatchingConf().getInclude();
        if (include != null && (includeAttribute = include.getAttribute()) instanceof Map) {
            return (Map)((Map)includeAttribute).get(key);
        }
        return null;
    }

    @Override
    public List<Metric> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        HashMap subMetrics = new HashMap();
        for (Map.Entry<String, List<String>> entry : this.subAttributeList.entrySet()) {
            String dataKey = entry.getKey();
            List<String> subSub = entry.getValue();
            for (String metricKey : subSub) {
                String alias = this.getAlias(metricKey);
                String metricType = this.getMetricType(metricKey);
                String[] tags = this.getTags(dataKey, metricKey);
                Metric metric = new Metric(alias, metricType, tags, this.checkName);
                double value = this.castToDouble(this.getValue(dataKey, metricKey), null);
                metric.setValue(value);
                String fullMetricKey = this.getAttributeName() + "." + metricKey;
                if (!subMetrics.containsKey(fullMetricKey)) {
                    subMetrics.put(fullMetricKey, new ArrayList());
                }
                ((List)subMetrics.get(fullMetricKey)).add(metric);
            }
        }
        ArrayList<Metric> metrics = new ArrayList<Metric>(subMetrics.keySet().size());
        for (String key : subMetrics.keySet()) {
            if (this.getAttributesFor(key) == null) continue;
            metrics.addAll(this.sortAndFilter(key, (List)subMetrics.get(key)));
        }
        return metrics;
    }

    private List<Metric> sortAndFilter(String metricKey, List<Metric> metrics) {
        Map<String, ?> attributes = this.getAttributesFor(metricKey);
        if (!attributes.containsKey("limit")) {
            return metrics;
        }
        Integer limit = (Integer)attributes.get("limit");
        if (metrics.size() <= limit) {
            return metrics;
        }
        MetricComparator comp = new MetricComparator();
        Collections.sort(metrics, comp);
        String sort = (String)attributes.get("sort");
        if (sort == null || sort.equals("desc")) {
            metrics.subList(0, limit).clear();
        } else {
            metrics.subList(metrics.size() - limit, metrics.size()).clear();
        }
        return metrics;
    }

    private Object getValue(String key, String subAttribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            Object value = this.getJmxValue();
            String attributeType = this.getAttribute().getType();
            TabularData data = (TabularData)value;
            for (Object rowKey : data.keySet()) {
                Collection keys = (Collection)rowKey;
                String pathKey = this.getMultiKey(keys);
                if (!key.equals(pathKey)) continue;
                CompositeData compositeData = data.get(keys.toArray());
                if (subAttribute.contains(".")) {
                    for (String subPathKey : subAttribute.split("\\.")) {
                        Object obj = compositeData.get(subPathKey);
                        if (!(obj instanceof CompositeData)) {
                            return compositeData.get(subPathKey);
                        }
                        compositeData = (CompositeData)obj;
                    }
                    continue;
                }
                return compositeData.get(subAttribute);
            }
        }
        catch (InvalidKeyException e) {
            log.warn("`" + this.getAttribute().getName() + "` attribute does not have a `" + subAttribute + "` key.");
            return null;
        }
        throw new NumberFormatException();
    }

    @Override
    public boolean match(Configuration configuration) {
        if (!this.matchDomain(configuration) || !this.matchClassName(configuration) || !this.matchBean(configuration) || this.excludeMatchDomain(configuration) || this.excludeMatchClassName(configuration) || this.excludeMatchBean(configuration)) {
            return false;
        }
        try {
            this.populateSubAttributeList(this.getJmxValue());
        }
        catch (Exception e) {
            return false;
        }
        return this.matchAttribute(configuration);
    }

    private boolean matchSubAttribute(Filter params, String subAttributeName, boolean matchOnEmpty) {
        if (params.getAttribute() instanceof Map && ((Map)params.getAttribute()).containsKey(subAttributeName)) {
            return true;
        }
        if (params.getAttribute() instanceof List && ((List)params.getAttribute()).contains(subAttributeName)) {
            return true;
        }
        if (params.getAttribute() == null) {
            return matchOnEmpty;
        }
        return false;
    }

    private boolean matchAttribute(Configuration configuration) {
        if (this.matchSubAttribute(configuration.getInclude(), this.getAttributeName(), true)) {
            return true;
        }
        Iterator<String> it1 = this.subAttributeList.keySet().iterator();
        while (it1.hasNext()) {
            String key = it1.next();
            List<String> subSub = this.subAttributeList.get(key);
            Iterator<String> it2 = subSub.iterator();
            while (it2.hasNext()) {
                String subKey = it2.next();
                if (this.matchSubAttribute(configuration.getInclude(), this.getAttributeName() + "." + subKey, true)) continue;
                it2.remove();
            }
            if (subSub.size() > 0) continue;
            it1.remove();
        }
        return this.subAttributeList.size() > 0;
    }

    private class MetricComparator
    implements Comparator<Metric> {
        private MetricComparator() {
        }

        @Override
        public int compare(Metric o1, Metric o2) {
            return Double.compare(o1.getValue(), o2.getValue());
        }
    }
}

