/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.datadog.jmxfetch.util.LogLevel;
import org.datadog.jmxfetch.util.StdoutConsoleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogger {
    private static final Logger log = LoggerFactory.getLogger(CustomLogger.class);
    private static java.util.logging.Logger jmxfetchLogger;
    private static final ConcurrentHashMap<String, AtomicInteger> messageCount;
    private static final String DATE_JDK14_LAYOUT = "yyyy-MM-dd HH:mm:ss z";
    private static final String DATE_JDK14_LAYOUT_RFC3339 = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String JDK14_LAYOUT = "%s | JMX | %2$s | %3$s | %4$s%5$s%n";
    private static final int MAX_FILE_SIZE = 0x500000;
    private static final int FILE_COUNT = 2;

    private static boolean isStdErr(String target) {
        List<String> stderrs = Arrays.asList("SYSTEM.ERR", "SYSTEM_ERR", "STDERR");
        return stderrs.contains(target.toUpperCase());
    }

    private static boolean isStdOut(String target) {
        List<String> stdouts = Arrays.asList("SYSTEM.OUT", "SYSTEM_OUT", "STDOUT");
        return stdouts.contains(target.toUpperCase());
    }

    public static synchronized void setup(LogLevel level, String logLocation, boolean logFormatRfc3339) {
        String target = "CONSOLE";
        String dateFormat = logFormatRfc3339 ? DATE_JDK14_LAYOUT_RFC3339 : DATE_JDK14_LAYOUT;
        final SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat, Locale.getDefault());
        SimpleFormatter formatter = new SimpleFormatter(){
            private static final String format = "%s | JMX | %2$s | %3$s | %4$s%5$s%n";

            private String simpleClassName(String str) {
                int start = str.lastIndexOf(46);
                int end = str.indexOf(36);
                if (start == -1 || start + 1 == str.length()) {
                    return str;
                }
                if (end == -1 || end <= start || end > str.length()) {
                    end = str.length();
                }
                return str.substring(start + 1, end);
            }

            @Override
            public synchronized String format(LogRecord lr) {
                String exception = "";
                if (lr.getThrown() != null) {
                    StringWriter writer = new StringWriter();
                    PrintWriter stream = new PrintWriter(writer);
                    stream.println();
                    lr.getThrown().printStackTrace(stream);
                    stream.close();
                    exception = writer.toString();
                }
                return String.format("%s | JMX | %2$s | %3$s | %4$s%5$s%n", dateFormatter.format(new Date()).toString(), LogLevel.fromJulLevel(lr.getLevel()).toString(), this.simpleClassName(lr.getSourceClassName()), lr.getMessage(), exception);
            }
        };
        Level julLevel = level.toJulLevel();
        LogManager manager = LogManager.getLogManager();
        manager.reset();
        StdoutConsoleHandler stdoutHandler = null;
        ConsoleHandler stderrHandler = null;
        FileHandler fileHandler = null;
        if (logLocation != null && logLocation.length() > 0) {
            if (!CustomLogger.isStdOut(logLocation) && !CustomLogger.isStdErr(logLocation)) {
                try {
                    fileHandler = new FileHandler(logLocation, 0x500000, 2);
                    fileHandler.setFormatter(formatter);
                }
                catch (Exception e) {
                    fileHandler = null;
                    log.error("can't open the file handler:", (Throwable)e);
                }
            } else if (CustomLogger.isStdErr(logLocation)) {
                stderrHandler = new ConsoleHandler();
                stderrHandler.setFormatter(formatter);
                stderrHandler.setLevel(julLevel);
            }
        }
        stdoutHandler = new StdoutConsoleHandler();
        stdoutHandler.setFormatter(formatter);
        stdoutHandler.setLevel(julLevel);
        jmxfetchLogger = java.util.logging.Logger.getLogger("org.datadog.jmxfetch");
        jmxfetchLogger.setLevel(julLevel);
        if (fileHandler != null) {
            jmxfetchLogger.addHandler(fileHandler);
        }
        if (stdoutHandler != null) {
            jmxfetchLogger.addHandler(stdoutHandler);
        }
        if (stderrHandler != null) {
            jmxfetchLogger.addHandler(stderrHandler);
        }
    }

    public static synchronized void shutdown() {
        for (Handler handler : jmxfetchLogger.getHandlers()) {
            if (handler == null) continue;
            handler.close();
            jmxfetchLogger.removeHandler(handler);
        }
    }

    public static void laconic(Logger logger, LogLevel level, String message, int max) {
        if (CustomLogger.shouldLog(message, max)) {
            if (level == LogLevel.ERROR) {
                logger.error(message);
            } else if (level == LogLevel.WARN) {
                logger.warn(message);
            } else if (level == LogLevel.INFO) {
                logger.info(message);
            } else if (level == LogLevel.DEBUG) {
                logger.debug(message);
            }
        }
    }

    private static boolean shouldLog(String message, int max) {
        AtomicInteger winner;
        AtomicInteger count = messageCount.get(message);
        if (null == count && (winner = messageCount.putIfAbsent(message, count = new AtomicInteger())) != null) {
            count = winner;
        }
        if (count.get() <= max) {
            count.getAndIncrement();
            return true;
        }
        return false;
    }

    private CustomLogger() {
    }

    static {
        messageCount = new ConcurrentHashMap();
    }
}

