/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.Metric;
import org.datadog.jmxfetch.service.ServiceNameProvider;

public class JmxSimpleAttribute
extends JmxAttribute {
    private Metric cachedMetric;

    public JmxSimpleAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String className, String instanceName, String checkName, Connection connection, ServiceNameProvider serviceNameProvider, Map<String, String> instanceTags, boolean cassandraAliasing, Boolean emptyDefaultHostname) {
        super(attribute, beanName, className, instanceName, checkName, connection, serviceNameProvider, instanceTags, cassandraAliasing, emptyDefaultHostname);
    }

    @Override
    public List<Metric> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if (this.cachedMetric == null) {
            String alias = this.getAlias(null);
            String metricType = this.getMetricType(null);
            String[] tags = this.getTags();
            this.cachedMetric = new Metric(alias, metricType, tags, this.checkName);
        }
        double value = this.castToDouble(this.getValue(), null);
        this.cachedMetric.setValue(value);
        return Collections.singletonList(this.cachedMetric);
    }

    @Override
    public boolean match(Configuration configuration) {
        return this.matchDomain(configuration) && this.matchClassName(configuration) && this.matchBean(configuration) && this.matchAttribute(configuration) && !this.excludeMatchDomain(configuration) && !this.excludeMatchClassName(configuration) && !this.excludeMatchBean(configuration) && !this.excludeMatchAttribute(configuration);
    }

    private boolean excludeMatchAttribute(Configuration configuration) {
        Filter exclude = configuration.getExclude();
        if (exclude.getAttribute() == null) {
            return false;
        }
        if (exclude.getAttribute() instanceof Map && ((Map)exclude.getAttribute()).containsKey(this.getAttributeName())) {
            return true;
        }
        return exclude.getAttribute() instanceof List && ((List)exclude.getAttribute()).contains(this.getAttributeName());
    }

    private boolean matchAttribute(Configuration configuration) {
        Filter include = configuration.getInclude();
        if (include.getAttribute() == null) {
            return true;
        }
        if (include.getAttribute() instanceof Map && ((Map)include.getAttribute()).containsKey(this.getAttributeName())) {
            return true;
        }
        return include.getAttribute() instanceof List && ((List)include.getAttribute()).contains(this.getAttributeName());
    }

    private Object getValue() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, NumberFormatException {
        return this.getJmxValue();
    }
}

