/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.timgroup.statsd.ServiceCheck;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datadog.jmxfetch.App;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Reporter {
    private static final Logger log = LoggerFactory.getLogger(Reporter.class);
    public static final String VALUE = "value";
    private Map<String, Integer> serviceCheckCount;
    private Map<String, Map<String, Map<String, Object>>> ratesAggregator = new HashMap<String, Map<String, Map<String, Object>>>();
    private Map<String, Map<String, Long>> countersAggregator = new HashMap<String, Map<String, Long>>();

    public Reporter() {
        this.serviceCheckCount = new HashMap<String, Integer>();
    }

    String generateId(Metric metric) {
        String key = metric.getAlias();
        StringBuilder sb = new StringBuilder(key);
        for (String tag : metric.getTags()) {
            sb.append(tag);
        }
        return sb.toString();
    }

    public void clearRatesAggregator(String instanceName) {
        this.ratesAggregator.put(instanceName, new HashMap());
    }

    public void clearCountersAggregator(String instanceName) {
        this.countersAggregator.put(instanceName, new HashMap());
    }

    public void sendMetrics(List<Metric> metrics, String instanceName, boolean canonicalRate) {
        Map<Object, Object> instanceRatesAggregator = this.ratesAggregator.containsKey(instanceName) ? this.ratesAggregator.get(instanceName) : new HashMap();
        Map<Object, Object> instanceCountersAggregator = this.countersAggregator.containsKey(instanceName) ? this.countersAggregator.get(instanceName) : new HashMap();
        int loopCounter = App.getLoopCounter();
        String sendingMessage = "Instance " + instanceName + " is sending " + metrics.size() + " metrics to the metrics reporter during collection #" + loopCounter;
        if (loopCounter <= 5 || loopCounter % 10 == 0) {
            log.info(sendingMessage);
            if (loopCounter == 5) {
                log.info("Next collections will be logged only every 10 collections.");
            }
        } else {
            log.debug(sendingMessage);
        }
        for (Metric metric : metrics) {
            boolean submit;
            String key;
            Double currentValue = metric.getValue();
            if (currentValue.isNaN() || currentValue.isInfinite()) continue;
            String metricName = metric.getAlias();
            String metricType = metric.getMetricType();
            String[] tags = metric.getTags();
            if (metricType.equals("gauge") || metricType.equals("histogram")) {
                this.sendMetricPoint(metricType, metricName, currentValue, tags);
                continue;
            }
            if (metricType.equals("monotonic_count")) {
                key = this.generateId(metric);
                if (!instanceCountersAggregator.containsKey(key)) {
                    instanceCountersAggregator.put(key, currentValue.longValue());
                    continue;
                }
                long oldValue = (Long)instanceCountersAggregator.get(key);
                long delta = currentValue.longValue() - oldValue;
                if (Double.isNaN(delta) || Double.isInfinite(delta)) continue;
                instanceCountersAggregator.put(key, currentValue.longValue());
                if (delta < 0L) {
                    log.info("Counter " + metricName + " has been reset - not submitting.");
                    continue;
                }
                this.sendMetricPoint(metricType, metricName, delta, tags);
                continue;
            }
            if (!metricType.equals("counter") && !metricType.equals("rate")) {
                log.debug("Invalid metric type " + metricType + " for metric " + metricName + ". The metric will be processed as rate (this is a DEPRECATED behaviour, use a valid type instead).");
            }
            if (!instanceRatesAggregator.containsKey(key = this.generateId(metric))) {
                HashMap<String, Number> rateInfo = new HashMap<String, Number>();
                rateInfo.put("ts", System.currentTimeMillis());
                rateInfo.put(VALUE, currentValue);
                instanceRatesAggregator.put(key, rateInfo);
                continue;
            }
            long oldTs = (Long)((Map)instanceRatesAggregator.get(key)).get("ts");
            double oldValue = (Double)((Map)instanceRatesAggregator.get(key)).get(VALUE);
            long now = System.currentTimeMillis();
            double rate = 1000.0 * (currentValue - oldValue) / (double)(now - oldTs);
            boolean sane = !Double.isNaN(rate) && !Double.isInfinite(rate);
            boolean bl = submit = rate >= 0.0 || !canonicalRate;
            if (sane && submit) {
                this.sendMetricPoint(metricType, metricName, rate, tags);
            } else if (sane) {
                log.info("Canonical rate option set, and negative rate (counter reset)not submitting.");
            }
            ((Map)instanceRatesAggregator.get(key)).put("ts", now);
            ((Map)instanceRatesAggregator.get(key)).put(VALUE, currentValue);
        }
        this.ratesAggregator.put(instanceName, instanceRatesAggregator);
        this.countersAggregator.put(instanceName, instanceCountersAggregator);
    }

    public void sendServiceCheck(String checkName, String serviceCheckName, String status, String message, String[] tags) {
        this.incrementServiceCheckCount(checkName);
        this.doSendServiceCheck(serviceCheckName, status, message, tags);
    }

    public void incrementServiceCheckCount(String checkName) {
        int scCount = this.getServiceCheckCount(checkName);
        this.getServiceCheckCountMap().put(checkName, new Integer(scCount + 1));
    }

    public int getServiceCheckCount(String checkName) {
        Integer scCount = this.serviceCheckCount.get(checkName);
        return scCount == null ? 0 : scCount;
    }

    public void resetServiceCheckCount(String checkName) {
        this.serviceCheckCount.put(checkName, new Integer(0));
    }

    protected Map<String, Integer> getServiceCheckCountMap() {
        return this.serviceCheckCount;
    }

    protected ServiceCheck.Status statusToServiceCheckStatus(String status) {
        if (status == "OK") {
            return ServiceCheck.Status.OK;
        }
        if (status == "WARNING") {
            return ServiceCheck.Status.WARNING;
        }
        if (status == "ERROR") {
            return ServiceCheck.Status.CRITICAL;
        }
        return ServiceCheck.Status.UNKNOWN;
    }

    protected int statusToServiceCheckStatusValue(String status) {
        ServiceCheck sc = ServiceCheck.builder().withStatus(this.statusToServiceCheckStatus(status)).build();
        return sc.getStatus();
    }

    protected abstract void sendMetricPoint(String var1, String var2, double var3, String[] var5);

    protected abstract void doSendServiceCheck(String var1, String var2, String var3, String[] var4);

    public abstract void displayMetricReached();

    public abstract void displayNonMatchingAttributeName(JmxAttribute var1);

    public abstract void displayInstanceName(Instance var1);

    public abstract void displayMatchingAttributeName(JmxAttribute var1, int var2, int var3);
}

